/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class PolicySubjectProcessor
extends BaseStAXArtifactProcessor {
    private PolicyFactory policyFactory;

    public PolicySubjectProcessor(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    public PolicySubjectProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = (PolicyFactory)factories.getFactory(PolicyFactory.class);
    }

    private void readIntents(Object subject, Operation operation, XMLStreamReader reader) {
        if (!(subject instanceof PolicySubject)) {
            return;
        }
        PolicySubject intentAttachPoint = (PolicySubject)subject;
        String value = reader.getAttributeValue(null, "requires");
        if (value != null) {
            List requiredIntents = intentAttachPoint.getRequiredIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                if (operation != null) {
                    // empty if block
                }
                requiredIntents.add(intent);
            }
        }
    }

    public void readPolicies(Object subject, Operation operation, XMLStreamReader reader) {
        this.readIntents(subject, operation, reader);
        this.readPolicySets(subject, operation, reader);
    }

    public void readPolicies(Object subject, XMLStreamReader reader) {
        this.readPolicies(subject, null, reader);
    }

    private void readPolicySets(Object subject, Operation operation, XMLStreamReader reader) {
        if (!(subject instanceof PolicySubject)) {
            return;
        }
        PolicySubject policySubject = (PolicySubject)subject;
        String value = reader.getAttributeValue(null, "policySets");
        if (value != null) {
            List policySets = policySubject.getPolicySets();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(qname);
                if (operation != null) {
                    // empty if block
                }
                policySets.add(policySet);
            }
        }
    }

    BaseStAXArtifactProcessor.XAttr writePolicies(Object subject) throws XMLStreamException {
        return this.writePolicies(subject, null);
    }

    public void writePolicyAttributes(Object subject, XMLStreamWriter writer) throws XMLStreamException {
        this.writePolicyAttributes(subject, null, writer);
    }

    BaseStAXArtifactProcessor.XAttr writePolicies(Object subject, Operation operation) {
        ArrayList<BaseStAXArtifactProcessor.XAttr> attrs = new ArrayList<BaseStAXArtifactProcessor.XAttr>();
        attrs.add(this.writeIntents(subject, operation));
        attrs.add(this.writePolicySets(subject, operation));
        return new BaseStAXArtifactProcessor.XAttr(null, attrs);
    }

    public void writePolicyAttributes(Object subject, Operation operation, XMLStreamWriter writer) throws XMLStreamException {
        BaseStAXArtifactProcessor.XAttr attr = this.writePolicies(subject, operation);
        attr.write(writer);
    }

    private BaseStAXArtifactProcessor.XAttr writeIntents(Object subject, Operation operation) {
        if (!(subject instanceof PolicySubject)) {
            return null;
        }
        PolicySubject intentAttachPoint = (PolicySubject)subject;
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (Intent intent : intentAttachPoint.getRequiredIntents()) {
            qnames.add(intent.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("requires", qnames);
    }

    private BaseStAXArtifactProcessor.XAttr writePolicySets(Object subject, Operation operation) {
        if (!(subject instanceof PolicySubject)) {
            return null;
        }
        PolicySubject policySetAttachPoint = (PolicySubject)subject;
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
            qnames.add(policySet.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("policySets", qnames);
    }

    public void resolvePolicies(Object subject, ModelResolver resolver, ProcessorContext context) {
        if (subject instanceof PolicySubject) {
            PolicySubject policySetAttachPoint = (PolicySubject)subject;
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            Intent resolvedIntent = null;
            if (policySetAttachPoint.getRequiredIntents() != null && policySetAttachPoint.getRequiredIntents().size() > 0) {
                for (Intent intent : policySetAttachPoint.getRequiredIntents()) {
                    resolvedIntent = (Intent)resolver.resolveModel(Intent.class, (Object)intent, context);
                    requiredIntents.add(resolvedIntent);
                }
                policySetAttachPoint.getRequiredIntents().clear();
                policySetAttachPoint.getRequiredIntents().addAll(requiredIntents);
            }
            if (policySetAttachPoint.getPolicySets() != null && policySetAttachPoint.getPolicySets().size() > 0) {
                ArrayList<PolicySet> resolvedPolicySets = new ArrayList<PolicySet>();
                PolicySet resolvedPolicySet = null;
                for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
                    resolvedPolicySet = (PolicySet)resolver.resolveModel(PolicySet.class, (Object)policySet, context);
                    resolvedPolicySets.add(resolvedPolicySet);
                }
                policySetAttachPoint.getPolicySets().clear();
                policySetAttachPoint.getPolicySets().addAll(resolvedPolicySets);
            }
        }
    }
}

