/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class EndpointReferenceProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<EndpointReference> {
    private static final String ENDPOINT_REFERENCE = "endpointReference";
    private static final QName ENDPOINT_REFERENCE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "endpointReference");
    private ExtensionPointRegistry registry;

    public EndpointReferenceProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        super(EndpointReferenceProcessor.modelFactories(registry), extensionProcessor);
        this.registry = registry;
    }

    private static FactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
    }

    public QName getArtifactType() {
        return ENDPOINT_REFERENCE_QNAME;
    }

    public EndpointReference read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Object model;
        EndpointReference endpointReference = this.assemblyFactory.createEndpointReference();
        if (reader.getEventType() == 7) {
            reader.nextTag();
        }
        if ((model = this.extensionProcessor.read(reader, context)) instanceof Composite) {
            Composite composite = (Composite)model;
            Component component = (Component)composite.getComponents().get(0);
            ComponentReference reference = (ComponentReference)component.getReferences().get(0);
            Binding binding = (Binding)reference.getBindings().get(0);
            endpointReference.setComponent(component);
            endpointReference.setReference(reference);
            reference.getEndpointReferences().add(endpointReference);
            endpointReference.setBinding(binding);
            Endpoint endpoint = this.assemblyFactory.createEndpoint();
            endpointReference.setTargetEndpoint(endpoint);
            if (reference.getTargets().size() > 0) {
                endpoint.setUnresolved(true);
                endpoint.setURI(((ComponentService)reference.getTargets().get(0)).getName());
                endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_NOT_FOUND);
                endpointReference.setUnresolved(true);
            } else {
                endpoint.setUnresolved(false);
                endpoint.setBinding((Binding)reference.getBindings().get(0));
                endpointReference.setStatus(EndpointReference.Status.RESOLVED_BINDING);
                endpointReference.setUnresolved(false);
            }
        }
        return endpointReference;
    }

    public void write(EndpointReference model, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.extensionProcessor.write((Object)this.wrap(model), writer, context);
    }

    private Composite wrap(EndpointReference endpointReference) {
        try {
            Composite composite = this.assemblyFactory.createComposite();
            composite.setName(ENDPOINT_REFERENCE_QNAME);
            composite.setLocal(false);
            Component component = (Component)endpointReference.getComponent().clone();
            composite.getComponents().add(component);
            component.getReferences().clear();
            component.getServices().clear();
            ComponentReference reference = (ComponentReference)endpointReference.getReference().clone();
            component.getReferences().add(reference);
            reference.getBindings().clear();
            Binding binding = (Binding)endpointReference.getBinding().clone();
            reference.getBindings().add(binding);
            if (endpointReference.getStatus() != EndpointReference.Status.RESOLVED_BINDING) {
                ComponentService service = this.assemblyFactory.createComponentService();
                service.setName(endpointReference.getTargetEndpoint().getURI());
                reference.getTargets().clear();
                reference.getTargets().add(service);
            }
            return composite;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Class<EndpointReference> getModelType() {
        return EndpointReference.class;
    }

    public void resolve(EndpointReference model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

