/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.definitions.DefinitionsFactory;
import org.apache.tuscany.sca.definitions.util.DefinitionsUtil;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class DefinitionsDocumentProcessor
implements URLArtifactProcessor<Definitions> {
    private StAXArtifactProcessor<Object> extensionProcessor;
    private XMLInputFactory inputFactory;
    private DefinitionsFactory definitionsFactory;

    public DefinitionsDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> staxProcessor) {
        this.extensionProcessor = staxProcessor;
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.definitionsFactory = (DefinitionsFactory)modelFactories.getFactory(DefinitionsFactory.class);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.definitions.xml.definitions-xml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    public Definitions read(URL contributionURL, URI uri, final URL url, ProcessorContext context) throws ContributionReadException {
        ContributionReadException ce;
        InputStream urlStream = null;
        Monitor monitor = context.getMonitor();
        monitor.pushContext((Object)("Definitions: " + url));
        try {
            try {
                urlStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        return IOHelper.openStream((URL)url);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.error(monitor, "PrivilegedActionException", url, (IOException)e.getException());
                throw (IOException)e.getException();
            }
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            ValidatingXMLInputFactory.setMonitor((XMLStreamReader)reader, (Monitor)context.getMonitor());
            Definitions definitions = this.definitionsFactory.createDefinitions();
            int event = reader.getEventType();
            while (reader.hasNext()) {
                event = reader.next();
                if (event != 1) continue;
                Object model = this.extensionProcessor.read(reader, context);
                if (model instanceof Definitions) {
                    DefinitionsUtil.aggregate((Definitions)((Definitions)model), (Definitions)definitions, (Monitor)monitor);
                    Definitions definitions2 = definitions;
                    return definitions2;
                }
                this.error(monitor, "ContributionReadException", model, null);
            }
            Definitions definitions3 = definitions;
            return definitions3;
        }
        catch (XMLStreamException e) {
            ce = new ContributionReadException((Throwable)e);
            this.error(monitor, "ContributionReadException", this.inputFactory, (Exception)((Object)ce));
            throw ce;
        }
        catch (IOException e) {
            ce = new ContributionReadException((Throwable)e);
            this.error(monitor, "ContributionReadException", this.inputFactory, (Exception)((Object)ce));
            throw ce;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
            monitor.popContext();
        }
    }

    public void resolve(Definitions scaDefinitions, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.extensionProcessor.resolve((Object)scaDefinitions, resolver, context);
    }

    public String getArtifactType() {
        return "/META-INF/definitions.xml";
    }

    public Class<Definitions> getModelType() {
        return Definitions.class;
    }
}

