/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class ComponentTypeModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<String, ComponentType> map = new HashMap<String, ComponentType>();

    public ComponentTypeModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    public void addModel(Object resolved, ProcessorContext context) {
        ComponentType componentType = (ComponentType)resolved;
        this.map.put(componentType.getURI(), componentType);
    }

    public Object removeModel(Object resolved, ProcessorContext context) {
        return this.map.remove(((ComponentType)resolved).getURI());
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        int s;
        String uri = ((ComponentType)unresolved).getURI();
        if (uri == null) {
            return unresolved;
        }
        ComponentType resolved = this.map.get(uri);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        if (unresolved instanceof ComponentType && (s = uri.lastIndexOf(47)) != -1) {
            String packageName = uri.substring(0, uri.lastIndexOf("/"));
            for (Import import_ : this.contribution.getImports()) {
                JavaImport javaImport;
                if (!(import_ instanceof JavaImport) || !(javaImport = (JavaImport)import_).getPackage().equals(packageName) || (resolved = (ComponentType)javaImport.getModelResolver().resolveModel(ComponentType.class, (Object)((ComponentType)unresolved), context)).isUnresolved()) continue;
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }
}

