/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AbstractService;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainingTypeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<ConstrainingType> {
    public ConstrainingTypeProcessor(AssemblyFactory assemblyFactory, ExtensionFactory extensionFactory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super(assemblyFactory, extensionFactory, policyFactory, extensionProcessor, extensionAttributeProcessor, monitor);
    }

    public ConstrainingTypeProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super((AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class), (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class), (PolicyFactory)modelFactories.getFactory(PolicyFactory.class), extensionProcessor, extensionAttributeProcessor, monitor);
    }

    public ConstrainingType read(XMLStreamReader reader) throws ContributionReadException {
        ConstrainingType constrainingType = null;
        AbstractService abstractService = null;
        AbstractReference abstractReference = null;
        AbstractProperty abstractProperty = null;
        AbstractService abstractContract = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        name = reader.getName();
                        if (Constants.CONSTRAINING_TYPE_QNAME.equals(name)) {
                            constrainingType = this.assemblyFactory.createConstrainingType();
                            constrainingType.setName(new QName(this.getString(reader, "targetNamespace"), this.getString(reader, "name")));
                            this.policyProcessor.readPolicies(constrainingType, reader);
                            break;
                        }
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            abstractContract = abstractService = this.assemblyFactory.createAbstractService();
                            abstractService.setName(this.getString(reader, "name"));
                            constrainingType.getServices().add(abstractService);
                            this.policyProcessor.readPolicies(abstractService, reader);
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            abstractReference = this.assemblyFactory.createAbstractReference();
                            abstractContract = abstractReference;
                            abstractReference.setName(this.getString(reader, "name"));
                            this.readMultiplicity(abstractReference, reader);
                            constrainingType.getReferences().add(abstractReference);
                            this.policyProcessor.readPolicies(abstractReference, reader);
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            abstractProperty = this.assemblyFactory.createAbstractProperty();
                            this.readAbstractProperty(abstractProperty, reader);
                            Document value = this.readPropertyValue(abstractProperty.getXSDElement(), abstractProperty.getXSDType(), reader);
                            abstractProperty.setValue((Object)value);
                            constrainingType.getProperties().add(abstractProperty);
                            this.policyProcessor.readPolicies(abstractProperty, reader);
                            break;
                        }
                        if (OPERATION_QNAME.equals(name)) {
                            OperationImpl operation = new OperationImpl();
                            operation.setName(this.getString(reader, "name"));
                            operation.setUnresolved(true);
                            this.policyProcessor.readPolicies(abstractContract, (Operation)operation, reader);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension instanceof InterfaceContract) {
                            abstractContract.setInterfaceContract((InterfaceContract)extension);
                            break;
                        }
                        if (abstractContract != null) {
                            abstractContract.getExtensions().add(extension);
                            break;
                        }
                        constrainingType.getExtensions().add(extension);
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (SERVICE_QNAME.equals(name)) {
                            abstractService = null;
                            abstractContract = null;
                            break;
                        }
                        if (REFERENCE_QNAME.equals(name)) {
                            abstractReference = null;
                            abstractContract = null;
                            break;
                        }
                        if (!PROPERTY_QNAME.equals(name)) break;
                        abstractProperty = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return constrainingType;
    }

    public void write(ConstrainingType constrainingType, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, "constrainingType", new BaseStAXArtifactProcessor.XAttr("targetNamespace", constrainingType.getName().getNamespaceURI()), new BaseStAXArtifactProcessor.XAttr("name", constrainingType.getName().getLocalPart()), this.policyProcessor.writePolicies(constrainingType));
        for (AbstractService service : constrainingType.getServices()) {
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
            this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
            for (Object extension : service.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (AbstractReference reference : constrainingType.getReferences()) {
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), this.writeMultiplicity(reference), this.policyProcessor.writePolicies(reference));
            this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
            for (Object extension : reference.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (AbstractProperty abstractProperty : constrainingType.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", abstractProperty.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(abstractProperty.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(abstractProperty.isMany())), new BaseStAXArtifactProcessor.XAttr("type", abstractProperty.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", abstractProperty.getXSDElement()), this.policyProcessor.writePolicies(abstractProperty));
            this.writePropertyValue(abstractProperty.getValue(), abstractProperty.getXSDElement(), abstractProperty.getXSDType(), writer);
            for (Object extension : abstractProperty.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Object extension : constrainingType.getExtensions()) {
            this.extensionProcessor.write(extension, writer);
        }
        this.writeEndDocument(writer);
    }

    public void resolve(ConstrainingType constrainingType, ModelResolver resolver) throws ContributionResolveException {
        this.resolveAbstractContracts(constrainingType.getServices(), resolver);
        this.resolveAbstractContracts(constrainingType.getReferences(), resolver);
        this.resolveIntents(constrainingType.getRequiredIntents(), resolver);
        for (AbstractService service : constrainingType.getServices()) {
            this.resolveIntents(service.getRequiredIntents(), resolver);
        }
        for (AbstractReference reference : constrainingType.getReferences()) {
            this.resolveIntents(reference.getRequiredIntents(), resolver);
        }
    }

    public QName getArtifactType() {
        return CONSTRAINING_TYPE_QNAME;
    }

    public Class<ConstrainingType> getModelType() {
        return ConstrainingType.class;
    }
}

