/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<QName, Composite> map = new HashMap<QName, Composite>();

    public CompositeModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    public void addModel(Object resolved) {
        Composite composite = (Composite)resolved;
        this.map.put(composite.getName(), composite);
    }

    public Object removeModel(Object resolved) {
        return this.map.remove(((Composite)resolved).getName());
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        QName qname = ((Composite)unresolved).getName();
        Composite resolved = this.map.get(qname);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport) || !(namespaceImport = (NamespaceImport)import_).getNamespace().equals(qname.getNamespaceURI()) || (resolved = (Composite)namespaceImport.getModelResolver().resolveModel(Composite.class, (Object)((Composite)unresolved))).isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        return unresolved;
    }
}

