/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTypeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<ComponentType> {
    public ComponentTypeProcessor(AssemblyFactory factory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super(factory, policyFactory, extensionProcessor, monitor);
    }

    public ComponentTypeProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super((AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class), (PolicyFactory)modelFactories.getFactory(PolicyFactory.class), extensionProcessor, monitor);
    }

    public ComponentType read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        ComponentType componentType = null;
        Service service = null;
        Reference reference = null;
        Service contract = null;
        Property property = null;
        Callback callback = null;
        QName name = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (Constants.COMPONENT_TYPE_QNAME.equals(name)) {
                        componentType = this.assemblyFactory.createComponentType();
                        componentType.setConstrainingType(this.readConstrainingType(reader));
                        break;
                    }
                    if (Constants.SERVICE_QNAME.equals(name)) {
                        contract = service = this.assemblyFactory.createService();
                        service.setName(this.getString(reader, "name"));
                        componentType.getServices().add(service);
                        this.policyProcessor.readPolicies(service, reader);
                        break;
                    }
                    if (Constants.REFERENCE_QNAME.equals(name)) {
                        reference = this.assemblyFactory.createReference();
                        contract = reference;
                        reference.setName(this.getString(reader, "name"));
                        reference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                        this.readMultiplicity((AbstractReference)reference, reader);
                        this.readTargets(reference, reader);
                        componentType.getReferences().add(reference);
                        this.policyProcessor.readPolicies(reference, reader);
                        break;
                    }
                    if (Constants.PROPERTY_QNAME.equals(name)) {
                        property = this.assemblyFactory.createProperty();
                        this.readAbstractProperty((AbstractProperty)property, reader);
                        this.policyProcessor.readPolicies(property, reader);
                        Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), reader);
                        property.setValue((Object)value);
                        componentType.getProperties().add(property);
                        break;
                    }
                    if (Constants.IMPLEMENTATION_QNAME.equals(name)) {
                        this.policyProcessor.readPolicies(componentType, reader);
                        break;
                    }
                    if (Constants.CALLBACK_QNAME.equals(name)) {
                        callback = this.assemblyFactory.createCallback();
                        contract.setCallback(callback);
                        this.policyProcessor.readPolicies(callback, reader);
                        break;
                    }
                    if (OPERATION_QNAME.equals(name)) {
                        OperationImpl operation = new OperationImpl();
                        operation.setName(this.getString(reader, "name"));
                        operation.setUnresolved(true);
                        if (callback != null) {
                            this.policyProcessor.readPolicies(callback, (Operation)operation, reader);
                            break;
                        }
                        this.policyProcessor.readPolicies(contract, (Operation)operation, reader);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null) break;
                    if (extension instanceof InterfaceContract) {
                        contract.setInterfaceContract((InterfaceContract)extension);
                        break;
                    }
                    if (extension instanceof Binding) {
                        if (callback != null) {
                            callback.getBindings().add((Binding)extension);
                            break;
                        }
                        contract.getBindings().add((Binding)extension);
                        break;
                    }
                    if (callback != null) {
                        callback.getExtensions().add(extension);
                        break;
                    }
                    if (contract != null) {
                        contract.getExtensions().add(extension);
                        break;
                    }
                    if (property != null) {
                        property.getExtensions().add(extension);
                        break;
                    }
                    if (!(componentType instanceof Extensible)) break;
                    ((Extensible)componentType).getExtensions().add(extension);
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (SERVICE_QNAME.equals(name)) {
                        service = null;
                        contract = null;
                        break;
                    }
                    if (REFERENCE_QNAME.equals(name)) {
                        reference = null;
                        contract = null;
                        break;
                    }
                    if (PROPERTY_QNAME.equals(name)) {
                        property = null;
                        break;
                    }
                    if (!CALLBACK_QNAME.equals(name)) break;
                    callback = null;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return componentType;
    }

    public void write(ComponentType componentType, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        Callback callback;
        this.writeStartDocument(writer, "componentType", this.writeConstrainingType(componentType));
        for (Service service : componentType.getServices()) {
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
            if (service.getInterfaceContract() != null) {
                this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
            }
            for (Binding binding : service.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (service.getCallback() != null) {
                callback = service.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension : service.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Reference reference : componentType.getReferences()) {
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), this.writeTargets(reference), this.policyProcessor.writePolicies(reference));
            this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
            for (Binding binding : reference.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (reference.getCallback() != null) {
                callback = reference.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension : reference.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Property property : componentType.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(property.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(property.isMany())), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), this.policyProcessor.writePolicies(property));
            this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
            for (Object extension : property.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        if (componentType instanceof Extensible) {
            for (Object extension : ((Extensible)componentType).getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
        }
        boolean writeImplementation = false;
        if (componentType instanceof IntentAttachPoint && !((IntentAttachPoint)componentType).getRequiredIntents().isEmpty()) {
            writeImplementation = true;
        }
        if (componentType instanceof PolicySetAttachPoint && !((PolicySetAttachPoint)componentType).getPolicySets().isEmpty()) {
            writeImplementation = true;
        }
        if (writeImplementation) {
            this.writeStart(writer, "implementation", this.policyProcessor.writePolicies(componentType));
        }
        this.writeEndDocument(writer);
    }

    public void resolve(ComponentType componentType, ModelResolver resolver) throws ContributionResolveException {
        this.resolveContracts(componentType.getServices(), resolver);
        this.resolveContracts(componentType.getReferences(), resolver);
        if (componentType instanceof PolicySetAttachPoint) {
            this.resolveIntents(((PolicySetAttachPoint)componentType).getRequiredIntents(), resolver);
            this.resolvePolicySets(((PolicySetAttachPoint)componentType).getPolicySets(), resolver);
        }
    }

    public QName getArtifactType() {
        return COMPONENT_TYPE_QNAME;
    }

    public Class<ComponentType> getModelType() {
        return ComponentType.class;
    }
}

