/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.rmi;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.host.rmi.RMIHostException;
import org.apache.tuscany.sca.host.rmi.RMIHostRuntimeException;
import org.apache.tuscany.sca.host.rmi.RMISocketFactoryImpl;

public class DefaultRMIHost
implements RMIHost {
    private static final Logger logger = Logger.getLogger(DefaultRMIHost.class.getName());
    private static final int CONNECTION_TIMEOUT = 3000;
    private Map<String, Registry> rmiRegistries = new ConcurrentHashMap<String, Registry>();
    private RMISocketFactory socketFactory = new RMISocketFactoryImpl(3000);

    @Override
    public String registerService(String uri, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        RMIURI rmiURI = new RMIURI(uri);
        try {
            Registry registry = this.rmiRegistries.get(Integer.toString(rmiURI.port));
            if (registry == null) {
                try {
                    registry = LocateRegistry.createRegistry(rmiURI.port, this.socketFactory, this.socketFactory);
                }
                catch (RemoteException e) {
                    registry = LocateRegistry.getRegistry(null, rmiURI.port, this.socketFactory);
                }
                this.rmiRegistries.put(Integer.toString(rmiURI.port), registry);
            }
            registry.bind(rmiURI.serviceName, serviceObject);
            logger.info("RMI service registered: " + rmiURI);
            return rmiURI.toString();
        }
        catch (AlreadyBoundException e) {
            throw new RMIHostException(e);
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
    }

    @Override
    public void unregisterService(String uri) throws RMIHostException, RMIHostRuntimeException {
        RMIURI rmiURI = new RMIURI(uri);
        try {
            Registry registry = this.rmiRegistries.get(Integer.toString(rmiURI.port));
            if (registry == null) {
                registry = LocateRegistry.getRegistry(null, rmiURI.port, this.socketFactory);
                this.rmiRegistries.put(Integer.toString(rmiURI.port), registry);
            }
            registry.unbind(rmiURI.serviceName);
            logger.info("RMI service unregistered: " + rmiURI);
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
        catch (NotBoundException e) {
            throw new RMIHostException(e.getMessage());
        }
    }

    @Override
    public Remote findService(String uri) throws RMIHostException, RMIHostRuntimeException {
        RMIURI rmiURI = new RMIURI(uri);
        Remote remoteService = null;
        try {
            Registry registry = LocateRegistry.getRegistry(rmiURI.host, rmiURI.port, this.socketFactory);
            if (registry != null) {
                remoteService = registry.lookup(rmiURI.serviceName);
            }
        }
        catch (RemoteException e) {
            RMIHostRuntimeException rmiExec = new RMIHostRuntimeException(e.getMessage());
            rmiExec.setStackTrace(e.getStackTrace());
            throw rmiExec;
        }
        catch (NotBoundException e) {
            throw new RMIHostException(e.getMessage());
        }
        return remoteService;
    }

    public void stop() {
        for (Registry registry : this.rmiRegistries.values()) {
            try {
                UnicastRemoteObject.unexportObject(registry, false);
            }
            catch (NoSuchObjectException e) {
                e.printStackTrace();
            }
        }
        this.rmiRegistries.clear();
    }

    private static class RMIURI {
        private String uriStr;
        private String host;
        private int port;
        private String serviceName;

        private RMIURI(String uriStr) {
            String path;
            URI uri = URI.create(uriStr);
            this.host = uri.getHost();
            if (this.host == null) {
                try {
                    this.host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.host = "localhost";
                }
            }
            this.port = uri.getPort();
            if (this.port <= 0) {
                this.port = 1099;
            }
            if ((path = uri.getPath()) != null && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            this.serviceName = path;
            this.uriStr = "rmi://" + this.host + ":" + this.port + "/" + this.serviceName;
        }

        public String toString() {
            return this.uriStr;
        }
    }
}

