/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.plugin.surefire;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.StringUtils;
import org.apache.maven.surefire.report.BriefConsoleReporter;
import org.apache.maven.surefire.report.BriefFileReporter;
import org.apache.maven.surefire.report.ConsoleReporter;
import org.apache.maven.surefire.report.DetailedConsoleReporter;
import org.apache.maven.surefire.report.FileReporter;
import org.apache.maven.surefire.report.ForkingConsoleReporter;
import org.apache.maven.surefire.report.XMLReporter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.apache.tuscany.maven.plugin.surefire.ForkConfiguration;
import org.apache.tuscany.maven.plugin.surefire.OSGiSurefireBooter;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.osgi.framework.Version;

public class OSGiSurefirePlugin
extends AbstractMojo {
    protected boolean skipTests;
    protected boolean skipExec;
    protected boolean skip;
    protected boolean testFailureIgnore;
    protected File basedir;
    protected File testClassesDirectory;
    protected File classesDirectory;
    protected MavenProject project;
    protected List classpathElements;
    protected List additionalClasspathElements;
    protected File reportsDirectory;
    protected File testSourceDirectory;
    protected String test;
    protected List includes;
    protected List excludes;
    protected ArtifactRepository localRepository;
    protected Properties systemProperties;
    protected Properties properties;
    protected Map pluginArtifactMap;
    protected String pluginGroupId;
    protected String pluginArtifactId;
    protected String pluginVersion;
    protected Map projectArtifactMap;
    protected boolean printSummary;
    protected String reportFormat;
    protected boolean useFile;
    protected boolean redirectTestOutputToFile;
    protected Boolean failIfNoTests;
    protected String forkMode;
    protected String jvm;
    protected String argLine;
    protected String debugForkedProcess;
    protected int forkedProcessTimeoutInSeconds;
    protected Map environmentVariables = new HashMap();
    protected File workingDirectory;
    protected boolean childDelegation;
    protected String groups;
    protected String excludedGroups;
    protected File[] suiteXmlFiles;
    protected String junitArtifactName;
    protected String testNGArtifactName;
    protected int threadCount;
    protected String parallel;
    protected boolean trimStackTrace;
    protected ArtifactResolver artifactResolver;
    protected ArtifactFactory artifactFactory;
    protected List remoteRepositories;
    protected ArtifactMetadataSource metadataSource;
    protected static final String BRIEF_REPORT_FORMAT = "brief";
    protected static final String PLAIN_REPORT_FORMAT = "plain";
    protected Properties originalSystemProperties;
    protected boolean disableXmlReport;
    protected Boolean useSystemClassLoader;
    protected boolean useManifestOnlyJar;
    protected boolean enableAssertions;
    protected MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            return;
        }
        if (this.verifyParameters()) {
            int result;
            OSGiSurefireBooter surefireBooter = this.constructSurefireBooter();
            Log log = this.getLog();
            HashSet<String> jarFiles = new HashSet<String>();
            Artifact ext = this.getArtifact("org.apache.tuscany.sca", "tuscany-extensibility-equinox");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Adding: " + ext));
            }
            jarFiles.add(ext.getFile().getAbsolutePath());
            Artifact con = this.getArtifact("org.apache.tuscany.sca", "tuscany-contribution-osgi");
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Adding: " + con));
            }
            jarFiles.add(con.getFile().getAbsolutePath());
            String name = this.project.getBuild().getFinalName();
            String mainBundleName = null;
            File mainJar = new File(this.project.getBuild().getDirectory(), name + "-osgi.jar");
            File testJar = new File(this.project.getBuild().getDirectory(), name + "-osgi-tests.jar");
            try {
                Manifest manifest = this.createMainBundle();
                mainBundleName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                int sc = mainBundleName.indexOf(59);
                if (sc != -1) {
                    mainBundleName = mainBundleName.substring(0, sc);
                }
                this.generateJar(this.classesDirectory, mainJar, manifest);
                Manifest testManifest = this.createTestFragment(manifest);
                this.generateJar(this.testClassesDirectory, testJar, testManifest);
                jarFiles.add(mainJar.getAbsolutePath());
                jarFiles.add(testJar.getAbsolutePath());
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Main bundle: " + mainBundleName));
            }
            surefireBooter.setMainBundleName(mainBundleName);
            for (String url : jarFiles) {
                surefireBooter.addClassPathUrl(url);
            }
            this.getLog().info((CharSequence)("Surefire report directory: " + this.reportsDirectory));
            try {
                result = surefireBooter.run();
            }
            catch (SurefireBooterForkException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            catch (SurefireExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.originalSystemProperties != null && !surefireBooter.isForking()) {
                System.setProperties(this.originalSystemProperties);
            }
            if (result == 0) {
                return;
            }
            if (result == 254) {
                if (this.failIfNoTests == null || !this.failIfNoTests.booleanValue()) {
                    return;
                }
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            String msg = "There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.";
            if (this.testFailureIgnore) {
                this.getLog().error((CharSequence)msg);
            } else {
                throw new MojoFailureException(msg);
            }
        }
    }

    protected boolean verifyParameters() throws MojoFailureException {
        if (this.skip || this.skipTests || this.skipExec) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        if (!this.testClassesDirectory.exists()) {
            if (this.failIfNoTests != null && this.failIfNoTests.booleanValue()) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
            return false;
        }
        if (this.useSystemClassLoader != null && "never".equals(this.forkMode)) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
        return true;
    }

    private void convertTestNGParameters() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.parallel != null) {
            this.properties.setProperty("parallel", this.parallel);
        }
        if (this.excludedGroups != null) {
            this.properties.setProperty("excludegroups", this.excludedGroups);
        }
        if (this.groups != null) {
            this.properties.setProperty("groups", this.groups);
        }
        if (this.threadCount > 0) {
            this.properties.setProperty("threadcount", new Integer(this.threadCount).toString());
        }
    }

    private OSGiSurefireBooter constructSurefireBooter() throws MojoExecutionException, MojoFailureException {
        Artifact testNgArtifact;
        Artifact junitArtifact;
        OSGiSurefireBooter surefireBooter = new OSGiSurefireBooter();
        Artifact osgiArtifact = this.artifactFactory.createArtifact(this.pluginGroupId, this.pluginArtifactId, this.pluginVersion, "test", "maven-plugin");
        try {
            this.artifactResolver.resolve(osgiArtifact, this.remoteRepositories, this.localRepository);
            surefireBooter.addSurefireBootClassPathUrl(osgiArtifact.getFile().getAbsolutePath());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to resolve " + osgiArtifact);
        }
        Artifact launcher = (Artifact)this.pluginArtifactMap.get("org.apache.tuscany.sca:tuscany-node-launcher-equinox");
        Artifact surefireArtifact = (Artifact)this.pluginArtifactMap.get("org.apache.maven.surefire:surefire-booter");
        if (surefireArtifact == null) {
            throw new MojoExecutionException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        surefireArtifact.isSnapshot();
        try {
            this.addArtifact(surefireBooter, surefireArtifact);
            this.addArtifact(surefireBooter, launcher);
            junitArtifact = (Artifact)this.projectArtifactMap.get(this.junitArtifactName);
            if (junitArtifact == null && "junit:junit".equals(this.junitArtifactName)) {
                junitArtifact = (Artifact)this.projectArtifactMap.get("junit:junit-dep");
            }
            if ((testNgArtifact = (Artifact)this.projectArtifactMap.get(this.testNGArtifactName)) != null) {
                VersionRange range = VersionRange.createFromVersionSpec((String)"[4.7,)");
                if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(testNgArtifact.getVersion()))) {
                    throw new MojoFailureException("TestNG support requires version 4.7 or above. You have declared version " + testNgArtifact.getVersion());
                }
                this.convertTestNGParameters();
                if (this.testClassesDirectory != null) {
                    this.properties.setProperty("testng.test.classpath", this.testClassesDirectory.getAbsolutePath());
                }
                this.addArtifact(surefireBooter, testNgArtifact);
                this.addProvider(surefireBooter, "surefire-testng", surefireArtifact.getBaseVersion(), testNgArtifact);
            } else if (junitArtifact != null && junitArtifact.getBaseVersion().startsWith("4")) {
                this.addProvider(surefireBooter, "surefire-junit4", surefireArtifact.getBaseVersion(), null);
            } else {
                this.addProvider(surefireBooter, "surefire-junit", surefireArtifact.getBaseVersion(), null);
            }
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to locate required surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Error determining the TestNG version requested: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Error to resolving surefire provider dependency: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.suiteXmlFiles != null && this.suiteXmlFiles.length > 0 && this.test == null) {
            if (testNgArtifact == null) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
            surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGXmlTestSuite", new Object[]{this.suiteXmlFiles, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
        } else {
            ArrayList<Object> excludes;
            ArrayList<Object> includes;
            if (this.test != null) {
                includes = new ArrayList();
                excludes = new ArrayList();
                if (this.failIfNoTests == null) {
                    this.failIfNoTests = Boolean.TRUE;
                }
                String[] testRegexes = StringUtils.split((String)this.test, (String)",");
                for (int i = 0; i < testRegexes.length; ++i) {
                    String testRegex = testRegexes[i];
                    if (testRegex.endsWith(".java")) {
                        testRegex = testRegex.substring(0, testRegex.length() - 5);
                    }
                    testRegex = testRegex.replace('.', '/');
                    includes.add("**/" + testRegex + ".java");
                }
            } else {
                includes = this.includes;
                excludes = this.excludes;
                if (includes == null || includes.size() == 0) {
                    includes = new ArrayList<String>(Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java"));
                }
                if (excludes == null || excludes.size() == 0) {
                    excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
                }
            }
            if (testNgArtifact != null) {
                surefireBooter.addTestSuite("org.apache.maven.surefire.testng.TestNGDirectoryTestSuite", new Object[]{this.testClassesDirectory, includes, excludes, this.testSourceDirectory.getAbsolutePath(), testNgArtifact.getVersion(), testNgArtifact.getClassifier(), this.properties, this.reportsDirectory});
            } else {
                String junitDirectoryTestSuite = junitArtifact != null && junitArtifact.getBaseVersion() != null && junitArtifact.getBaseVersion().startsWith("4") ? "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite" : "org.apache.maven.surefire.junit.JUnitDirectoryTestSuite";
                surefireBooter.addTestSuite(junitDirectoryTestSuite, new Object[]{this.testClassesDirectory, includes, excludes});
            }
        }
        this.getLog().debug((CharSequence)"Test Classpath :");
        this.classpathElements.remove(this.classesDirectory.getAbsolutePath());
        this.classpathElements.remove(this.testClassesDirectory.getAbsolutePath());
        for (String classpathElement : this.classpathElements) {
            this.getLog().debug((CharSequence)("  " + classpathElement));
            surefireBooter.addClassPathUrl(classpathElement);
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in surefire-plugin: " + tc));
            if ("never".equals(this.forkMode)) {
                this.forkMode = "once";
            }
            if (this.jvm != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.jvm));
            } else {
                this.jvm = tc.findTool("java");
            }
        }
        if (this.additionalClasspathElements != null) {
            for (String classpathElement : this.additionalClasspathElements) {
                this.getLog().debug((CharSequence)("  " + classpathElement));
                surefireBooter.addClassPathUrl(classpathElement);
            }
        }
        ForkConfiguration fork = new ForkConfiguration();
        fork.setForkMode(this.forkMode);
        this.processSystemProperties(!fork.isForking());
        if (this.getLog().isDebugEnabled()) {
            this.showMap(this.systemProperties, "system property");
        }
        if (fork.isForking()) {
            List<String> args;
            this.useSystemClassLoader = this.useSystemClassLoader == null ? Boolean.TRUE : this.useSystemClassLoader;
            fork.setUseSystemClassLoader(this.useSystemClassLoader);
            fork.setUseManifestOnlyJar(this.useManifestOnlyJar);
            fork.setSystemProperties(this.systemProperties);
            if ("true".equals(this.debugForkedProcess)) {
                this.debugForkedProcess = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
            }
            fork.setDebugLine(this.debugForkedProcess);
            if (this.jvm == null || "".equals(this.jvm)) {
                this.jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
                this.getLog().debug((CharSequence)("Using JVM: " + this.jvm));
            }
            fork.setJvmExecutable(this.jvm);
            if (this.workingDirectory != null) {
                fork.setWorkingDirectory(this.workingDirectory);
            } else {
                fork.setWorkingDirectory(this.basedir);
            }
            fork.setArgLine(this.argLine);
            fork.setEnvironmentVariables(this.environmentVariables);
            if (this.getLog().isDebugEnabled()) {
                this.showMap(this.environmentVariables, "environment variable");
                fork.setDebug(true);
            }
            if (this.argLine != null && ((args = Arrays.asList(this.argLine.split(" "))).contains("-da") || args.contains("-disableassertions"))) {
                this.enableAssertions = false;
            }
        }
        surefireBooter.setFailIfNoTests(this.failIfNoTests == null ? false : this.failIfNoTests);
        surefireBooter.setForkedProcessTimeoutInSeconds(this.forkedProcessTimeoutInSeconds);
        surefireBooter.setRedirectTestOutputToFile(this.redirectTestOutputToFile);
        surefireBooter.setForkConfiguration(fork);
        surefireBooter.setChildDelegation(this.childDelegation);
        surefireBooter.setEnableAssertions(this.enableAssertions);
        surefireBooter.setReportsDirectory(this.reportsDirectory);
        this.addReporters(surefireBooter, fork.isForking());
        return surefireBooter;
    }

    private void showMap(Map map, String setting) {
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private void addProvider(OSGiSurefireBooter surefireBooter, String provider, String version, Artifact filteredArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact providerArtifact = this.artifactFactory.createDependencyArtifact("org.apache.maven.surefire", provider, VersionRange.createFromVersion((String)version), "jar", null, "test");
        ArtifactResolutionResult result = this.resolveArtifact(filteredArtifact, providerArtifact);
        for (Artifact artifact : result.getArtifacts()) {
            String key = ArtifactUtils.versionlessKey((Artifact)artifact);
            if ("junit:junit".equals(key) || "jnuit:junit-dep".equals(key)) continue;
            this.getLog().debug((CharSequence)("Adding to surefire test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) throws ArtifactResolutionException, ArtifactNotFoundException {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        return this.artifactResolver.resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, (ArtifactFilter)filter);
    }

    private void addArtifact(OSGiSurefireBooter surefireBooter, Artifact surefireArtifact) throws ArtifactNotFoundException, ArtifactResolutionException {
        ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
        for (Artifact artifact : result.getArtifacts()) {
            this.getLog().debug((CharSequence)("Adding to surefire booter test classpath: " + artifact.getFile().getAbsolutePath()));
            surefireBooter.addSurefireBootClassPathUrl(artifact.getFile().getAbsolutePath());
        }
    }

    protected void processSystemProperties(boolean setInSystem) {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        this.originalSystemProperties = (Properties)System.getProperties().clone();
        Properties userSpecifiedProperties = (Properties)this.session.getExecutionProperties().clone();
        userSpecifiedProperties.putAll((Map<?, ?>)this.systemProperties);
        this.systemProperties.setProperty("basedir", this.basedir.getAbsolutePath());
        this.systemProperties.setProperty("user.dir", this.workingDirectory.getAbsolutePath());
        this.systemProperties.setProperty("localRepository", this.localRepository.getBasedir());
        if (setInSystem) {
            for (String string : this.systemProperties.keySet()) {
                String value = this.systemProperties.getProperty(string);
                System.setProperty(string, value);
            }
        }
    }

    private void addReporters(OSGiSurefireBooter surefireBooter, boolean forking) {
        Boolean trimStackTrace = this.trimStackTrace;
        if (this.useFile) {
            if (this.printSummary) {
                if (forking) {
                    surefireBooter.addReport(ForkingConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                } else {
                    surefireBooter.addReport(ConsoleReporter.class.getName(), new Object[]{trimStackTrace});
                }
            }
            if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport(BriefFileReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
                surefireBooter.addReport(FileReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
            }
        } else if (BRIEF_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport(BriefConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        } else if (PLAIN_REPORT_FORMAT.equals(this.reportFormat)) {
            surefireBooter.addReport(DetailedConsoleReporter.class.getName(), new Object[]{trimStackTrace});
        }
        if (!this.disableXmlReport) {
            surefireBooter.addReport(XMLReporter.class.getName(), new Object[]{this.reportsDirectory, trimStackTrace});
        }
    }

    public boolean isSkipExec() {
        return this.skipTests;
    }

    public void setSkipExec(boolean skipExec) {
        this.skipTests = skipExec;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        try {
            ToolchainManager toolchainManager;
            if (this.session != null && (toolchainManager = (ToolchainManager)this.session.getContainer().lookup(ToolchainManager.ROLE)) != null) {
                tc = toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return tc;
    }

    protected Artifact getArtifact(String groupId, String artifactId) throws MojoExecutionException {
        VersionRange vr;
        try {
            vr = VersionRange.createFromVersionSpec((String)this.project.getVersion());
        }
        catch (InvalidVersionSpecificationException e1) {
            vr = VersionRange.createFromVersion((String)this.project.getVersion());
        }
        Artifact artifact = this.artifactFactory.createDependencyArtifact(groupId, artifactId, vr, "jar", null, "test");
        try {
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private void generateJar(File root, File jar, Manifest mf) throws IOException {
        this.getLog().info((CharSequence)("Generating " + jar.toString()));
        FileOutputStream fos = new FileOutputStream(jar);
        JarOutputStream jos = mf != null ? new JarOutputStream((OutputStream)fos, mf) : new JarOutputStream(fos);
        this.addDir(jos, root, root);
        jos.close();
    }

    static String osgiVersion(String mavenVersion) {
        DefaultArtifactVersion ver = new DefaultArtifactVersion(mavenVersion);
        String qualifer = ver.getQualifier();
        if (qualifer != null) {
            StringBuffer buf = new StringBuffer(qualifer);
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                buf.setCharAt(i, '_');
            }
            qualifer = buf.toString();
        }
        Version osgiVersion = new Version(ver.getMajorVersion(), ver.getMinorVersion(), ver.getIncrementalVersion(), qualifer);
        String version = osgiVersion.toString();
        return version;
    }

    private Manifest createMainBundle() throws IOException {
        String bundleName;
        File mf = new File(this.project.getBasedir(), "META-INF/MANIFEST.MF");
        Manifest manifest = null;
        if (mf.isFile() && (bundleName = (manifest = new Manifest(new FileInputStream(mf))).getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
            return manifest;
        }
        if (manifest == null) {
            manifest = new Manifest();
        }
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        attributes.putValue("Bundle-SymbolicName", this.project.getGroupId() + "." + this.project.getArtifactId());
        attributes.putValue("Bundle-Name", this.project.getName());
        attributes.putValue("Bundle-Version", OSGiSurefirePlugin.osgiVersion(this.project.getVersion()));
        attributes.putValue("DynamicImport-Package", "*");
        return manifest;
    }

    private Manifest createTestFragment(Manifest mf) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Bundle-ManifestVersion", "2");
        String host = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        int sc = host.indexOf(59);
        if (sc != -1) {
            host = host.substring(0, sc);
        }
        attributes.putValue("Bundle-SymbolicName", host + ".tests");
        attributes.putValue("Bundle-Name", mf.getMainAttributes().getValue("Bundle-Name") + " Tests");
        attributes.putValue("Bundle-Version", mf.getMainAttributes().getValue("Bundle-Version"));
        attributes.putValue("Fragment-Host", host + ";bundle-version=\"" + mf.getMainAttributes().getValue("Bundle-Version") + "\"");
        attributes.putValue("DynamicImport-Package", "*");
        return manifest;
    }

    private void addDir(JarOutputStream jos, File root, File dir) throws IOException, FileNotFoundException {
        for (File file : dir.listFiles()) {
            int len;
            String uri;
            if (file.isDirectory()) {
                this.addDir(jos, root, file);
                continue;
            }
            if (!file.isFile() || "META-INF/MANIFEST.MF".equals(uri = root.toURI().relativize(file.toURI()).toString())) continue;
            ZipEntry entry = new ZipEntry(uri);
            jos.putNextEntry(entry);
            byte[] buf = new byte[4096];
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(buf)) > 0) {
                jos.write(buf, 0, len);
            }
            in.close();
            jos.closeEntry();
        }
    }
}

