/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.util.ArrayList;
import org.apache.tomcat.util.bcel.classfile.AccessFlags;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.Annotations;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.Utility;
import org.apache.tomcat.util.bcel.util.BCELComparator;

public class JavaClass
extends AccessFlags
implements Cloneable,
Comparable<JavaClass> {
    private static final long serialVersionUID = 7029227708237523236L;
    private String class_name;
    private String superclass_name;
    private String[] interface_names;
    private Attribute[] attributes;
    private AnnotationEntry[] annotations;
    private boolean annotationsOutOfDate = true;
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return THIS.getClassName().equals(THAT.getClassName());
        }

        @Override
        public int hashCode(Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };

    public JavaClass(int class_name_index, int superclass_name_index, int access_flags, ConstantPool constant_pool, int[] interfaces, Attribute[] attributes) {
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        this.access_flags = access_flags;
        this.attributes = attributes;
        this.annotationsOutOfDate = true;
        this.class_name = constant_pool.getConstantString(class_name_index, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        if (superclass_name_index > 0) {
            this.superclass_name = constant_pool.getConstantString(superclass_name_index, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String str = constant_pool.getConstantString(interfaces[i], (byte)7);
            this.interface_names[i] = Utility.compactClassName(str, false);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotationsOutOfDate) {
            Attribute[] attrs = this.getAttributes();
            ArrayList<AnnotationEntry> accumulatedAnnotations = new ArrayList<AnnotationEntry>();
            for (int i = 0; i < attrs.length; ++i) {
                Attribute attribute = attrs[i];
                if (!(attribute instanceof Annotations)) continue;
                Annotations runtimeAnnotations = (Annotations)attribute;
                for (int j = 0; j < runtimeAnnotations.getAnnotationEntries().length; ++j) {
                    accumulatedAnnotations.add(runtimeAnnotations.getAnnotationEntries()[j]);
                }
            }
            this.annotations = accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
            this.annotationsOutOfDate = false;
        }
        return this.annotations;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public boolean equals(Object obj) {
        return _cmp.equals(this, obj);
    }

    @Override
    public int compareTo(JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

