/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.Attribute;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;

public final class ExceptionTable
extends Attribute {
    private static final long serialVersionUID = -5109672682663772900L;
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(int name_index, int length, int[] exception_index_table, ConstantPool constant_pool) {
        super(name_index, length, constant_pool);
        this.setExceptionIndexTable(exception_index_table);
    }

    ExceptionTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        this.number_of_exceptions = file.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        for (int i = 0; i < this.number_of_exceptions; ++i) {
            this.exception_index_table[i] = file.readUnsignedShort();
        }
    }

    public final void setExceptionIndexTable(int[] exception_index_table) {
        this.exception_index_table = exception_index_table;
        this.number_of_exceptions = exception_index_table == null ? 0 : exception_index_table.length;
    }
}

