/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.factory.AbstractTilesContainerFactory;

public class TilesListener
implements ServletContextListener {
    public static final String CONTAINER_KEY_INIT_PARAMETER = "org.apache.tiles.web.startup.TilesListener.CONTAINER_KEY";
    protected static final Log LOG = LogFactory.getLog(TilesListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        String key = servletContext.getInitParameter(CONTAINER_KEY_INIT_PARAMETER);
        TilesContainer container = this.createContainer(servletContext);
        TilesAccess.setContainer((Object)servletContext, (TilesContainer)container, (String)key);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            TilesAccess.setContainer((Object)servletContext, null);
        }
        catch (TilesException e) {
            LOG.warn((Object)"Unable to remove tiles container from service.", (Throwable)e);
        }
    }

    protected TilesContainer createContainer(ServletContext context) {
        AbstractTilesContainerFactory factory = AbstractTilesContainerFactory.getTilesContainerFactory((Object)context);
        return factory.createContainer((Object)context);
    }
}

