/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.startup;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.definition.util.DefinitionsFactoryUtil;
import org.apache.tiles.web.startup.TilesServlet;

public class TilesFilter
extends TilesServlet
implements Filter {
    private static final Log LOG = LogFactory.getLog(TilesFilter.class);
    private FilterConfig filterConfig = null;
    private String containerKey;
    private static final boolean DEBUG = true;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            DefinitionsFactoryUtil.reloadDefinitionsFactory((Object)this.getServletContext(), (String)this.containerKey);
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            throw new ServletException("Error processing request.", (Throwable)e);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        super.destroy();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        super.init(this.createServletConfig());
        this.containerKey = filterConfig.getInitParameter("org.apache.tiles.web.startup.TilesListener.CONTAINER_KEY");
        this.log("TilesDecorationFilter:Initializing filter");
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }

    private ServletConfig createServletConfig() {
        return new ServletConfigAdapter(this.filterConfig);
    }

    class ServletConfigAdapter
    implements ServletConfig {
        private FilterConfig config;

        public ServletConfigAdapter(FilterConfig config) {
            this.config = config;
        }

        public String getServletName() {
            return this.config.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String string) {
            return this.config.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }
    }
}

