/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context.wildcard;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardServletTilesApplicationContext
extends ServletTilesApplicationContext {
    protected ResourcePatternResolver resolver;

    public WildcardServletTilesApplicationContext(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public void initialize(ServletContext context) {
        super.initialize(context);
        this.resolver = new ServletContextResourcePatternResolver(context);
    }

    @Override
    public URL getResource(String path) throws IOException {
        URL retValue = null;
        Set<URL> urlSet = this.getResources(path);
        if (urlSet != null && !urlSet.isEmpty()) {
            retValue = urlSet.iterator().next();
        }
        return retValue;
    }

    @Override
    public Set<URL> getResources(String path) throws IOException {
        HashSet<URL> urlSet = null;
        Resource[] resources = this.resolver.getResources(path);
        if (resources != null && resources.length > 0) {
            urlSet = new HashSet<URL>();
            for (int i = 0; i < resources.length; ++i) {
                urlSet.add(resources[i].getURL());
            }
        }
        return urlSet;
    }
}

