/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.impl.NoSuchContainerException;

public final class ServletUtil {
    public static final String FORCE_INCLUDE_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.FORCE_INCLUDE";
    public static final String CURRENT_CONTAINER_ATTRIBUTE_NAME = "org.apache.tiles.servlet.context.ServletTilesRequestContext.CURRENT_CONTAINER_KEY";

    private ServletUtil() {
    }

    public static boolean isForceInclude(HttpServletRequest request) {
        Boolean retValue = (Boolean)request.getAttribute(FORCE_INCLUDE_ATTRIBUTE_NAME);
        return retValue != null && retValue != false;
    }

    public static void setForceInclude(HttpServletRequest request, boolean forceInclude) {
        Boolean retValue = forceInclude;
        request.setAttribute(FORCE_INCLUDE_ATTRIBUTE_NAME, (Object)retValue);
    }

    public static void setCurrentContainer(ServletRequest request, ServletContext context, String key) {
        TilesContainer container = TilesAccess.getContainer((Object)context, (String)key);
        if (container == null) {
            throw new NoSuchContainerException("The container with the key '" + key + "' cannot be found");
        }
        request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
    }

    public static void setCurrentContainer(ServletRequest request, ServletContext context, TilesContainer container) {
        if (container == null) {
            throw new NoSuchContainerException("The container cannot be null");
        }
        request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
    }

    public static TilesContainer getCurrentContainer(ServletRequest request, ServletContext context) {
        TilesContainer container = (TilesContainer)request.getAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME);
        if (container == null) {
            container = TilesAccess.getContainer((Object)context);
            request.setAttribute(CURRENT_CONTAINER_ATTRIBUTE_NAME, (Object)container);
        }
        return container;
    }
}

