/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.complete;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.compat.definition.digester.CompatibilityDigesterDefinitionsReader;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContextHolder;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.DefinitionsReader;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PrefixedPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.regexp.RegexpDefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.el.JspExpressionFactoryFactory;
import org.apache.tiles.el.TilesContextBeanELResolver;
import org.apache.tiles.el.TilesContextELResolver;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.freemarker.context.FreeMarkerTilesRequestContextFactory;
import org.apache.tiles.freemarker.renderer.FreeMarkerAttributeRenderer;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.mvel.MVELAttributeEvaluator;
import org.apache.tiles.mvel.TilesContextBeanVariableResolverFactory;
import org.apache.tiles.mvel.TilesContextVariableResolverFactory;
import org.apache.tiles.ognl.ApplicationScopeNestedObjectExtractor;
import org.apache.tiles.ognl.DelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectDelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectExtractor;
import org.apache.tiles.ognl.OGNLAttributeEvaluator;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.ognl.RequestScopeNestedObjectExtractor;
import org.apache.tiles.ognl.SessionScopeNestedObjectExtractor;
import org.apache.tiles.ognl.TilesApplicationContextNestedObjectExtractor;
import org.apache.tiles.ognl.TilesContextPropertyAccessorDelegateFactory;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.TypeDetectingAttributeRenderer;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.apache.tiles.renderer.impl.ChainedDelegateAttributeRenderer;
import org.apache.tiles.util.URLUtil;
import org.apache.tiles.velocity.context.VelocityTilesRequestContextFactory;
import org.apache.tiles.velocity.renderer.VelocityAttributeRenderer;
import org.mvel2.integration.VariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteAutoloadTilesContainerFactory
extends BasicTilesContainerFactory {
    private static final String FREEMARKER_RENDERER_NAME = "freemarker";
    private static final String VELOCITY_RENDERER_NAME = "velocity";

    protected BasicTilesContainer instantiateContainer(TilesApplicationContext applicationContext) {
        return new CachingTilesContainer();
    }

    protected List<TilesRequestContextFactory> getTilesRequestContextFactoriesToBeChained(ChainedTilesRequestContextFactory parent) {
        List factories = super.getTilesRequestContextFactoriesToBeChained(parent);
        this.registerRequestContextFactory(FreeMarkerTilesRequestContextFactory.class.getName(), factories, (TilesRequestContextFactory)parent);
        this.registerRequestContextFactory(VelocityTilesRequestContextFactory.class.getName(), factories, (TilesRequestContextFactory)parent);
        return factories;
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        super.registerAttributeRenderers(rendererFactory, applicationContext, contextFactory, container, attributeEvaluatorFactory);
        FreeMarkerAttributeRenderer freemarkerRenderer = new FreeMarkerAttributeRenderer();
        freemarkerRenderer.setApplicationContext(applicationContext);
        freemarkerRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        freemarkerRenderer.setRequestContextFactory(contextFactory);
        freemarkerRenderer.setParameter("TemplatePath", "/");
        freemarkerRenderer.setParameter("NoCache", "true");
        freemarkerRenderer.setParameter("ContentType", "text/html");
        freemarkerRenderer.setParameter("template_update_delay", "0");
        freemarkerRenderer.setParameter("default_encoding", "ISO-8859-1");
        freemarkerRenderer.setParameter("number_format", "0.##########");
        freemarkerRenderer.commit();
        rendererFactory.registerRenderer(FREEMARKER_RENDERER_NAME, (AttributeRenderer)freemarkerRenderer);
        VelocityAttributeRenderer velocityRenderer = new VelocityAttributeRenderer();
        velocityRenderer.setApplicationContext(applicationContext);
        velocityRenderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        velocityRenderer.setRequestContextFactory(contextFactory);
        velocityRenderer.commit();
        rendererFactory.registerRenderer(VELOCITY_RENDERER_NAME, (AttributeRenderer)velocityRenderer);
    }

    protected AttributeRenderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateAttributeRenderer retValue = new ChainedDelegateAttributeRenderer();
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("definition"));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(VELOCITY_RENDERER_NAME));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer(FREEMARKER_RENDERER_NAME));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("template"));
        retValue.addAttributeRenderer((TypeDetectingAttributeRenderer)rendererFactory.getRenderer("string"));
        retValue.setApplicationContext(applicationContext);
        retValue.setRequestContextFactory(contextFactory);
        retValue.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory, LocaleResolver resolver) {
        BasicAttributeEvaluatorFactory attributeEvaluatorFactory = new BasicAttributeEvaluatorFactory((AttributeEvaluator)this.createELEvaluator(applicationContext));
        attributeEvaluatorFactory.registerAttributeEvaluator("MVEL", (AttributeEvaluator)this.createMVELEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator("OGNL", (AttributeEvaluator)this.createOGNLEvaluator());
        return attributeEvaluatorFactory;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory wildcardFactory = new WildcardDefinitionPatternMatcherFactory();
        RegexpDefinitionPatternMatcherFactory regexpFactory = new RegexpDefinitionPatternMatcherFactory();
        PrefixedPatternDefinitionResolver resolver = new PrefixedPatternDefinitionResolver();
        resolver.registerDefinitionPatternMatcherFactory("WILDCARD", (DefinitionPatternMatcherFactory)wildcardFactory);
        resolver.registerDefinitionPatternMatcherFactory("REGEXP", (DefinitionPatternMatcherFactory)regexpFactory);
        return resolver;
    }

    protected List<URL> getSourceURLs(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        try {
            Set urlSet = applicationContext.getResources("/WEB-INF/**/tiles*.xml");
            urlSet.addAll(applicationContext.getResources("classpath*:META-INF/**/tiles*.xml"));
            return URLUtil.getBaseTilesDefinitionURLs((Collection)urlSet);
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Cannot load definition URLs", (Exception)e);
        }
    }

    protected DefinitionsReader createDefinitionsReader(TilesApplicationContext applicationContext, TilesRequestContextFactory contextFactory) {
        return new CompatibilityDigesterDefinitionsReader();
    }

    private ELAttributeEvaluator createELEvaluator(TilesApplicationContext applicationContext) {
        ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
        evaluator.setApplicationContext(applicationContext);
        JspExpressionFactoryFactory efFactory = new JspExpressionFactoryFactory();
        efFactory.setApplicationContext(applicationContext);
        evaluator.setExpressionFactory(efFactory.getExpressionFactory());
        CompositeELResolver elResolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new TilesContextELResolver());
                this.add((ELResolver)new TilesContextBeanELResolver());
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)new BeanELResolver(false));
            }
        };
        evaluator.setResolver((ELResolver)elResolver);
        return evaluator;
    }

    private MVELAttributeEvaluator createMVELEvaluator() {
        TilesRequestContextHolder requestHolder = new TilesRequestContextHolder();
        TilesContextVariableResolverFactory variableResolverFactory = new TilesContextVariableResolverFactory(requestHolder);
        variableResolverFactory.setNextFactory((VariableResolverFactory)new TilesContextBeanVariableResolverFactory(requestHolder));
        MVELAttributeEvaluator mvelEvaluator = new MVELAttributeEvaluator(requestHolder, (VariableResolverFactory)variableResolverFactory);
        return mvelEvaluator;
    }

    private OGNLAttributeEvaluator createOGNLEvaluator() {
        try {
            PropertyAccessor objectPropertyAccessor = OgnlRuntime.getPropertyAccessor(Object.class);
            PropertyAccessor mapPropertyAccessor = OgnlRuntime.getPropertyAccessor(Map.class);
            NestedObjectDelegatePropertyAccessor applicationContextPropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new TilesApplicationContextNestedObjectExtractor(), objectPropertyAccessor);
            NestedObjectDelegatePropertyAccessor requestScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new RequestScopeNestedObjectExtractor(), mapPropertyAccessor);
            NestedObjectDelegatePropertyAccessor sessionScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new SessionScopeNestedObjectExtractor(), mapPropertyAccessor);
            NestedObjectDelegatePropertyAccessor applicationScopePropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new ApplicationScopeNestedObjectExtractor(), mapPropertyAccessor);
            TilesContextPropertyAccessorDelegateFactory factory = new TilesContextPropertyAccessorDelegateFactory(objectPropertyAccessor, (PropertyAccessor)applicationContextPropertyAccessor, (PropertyAccessor)requestScopePropertyAccessor, (PropertyAccessor)sessionScopePropertyAccessor, (PropertyAccessor)applicationScopePropertyAccessor);
            DelegatePropertyAccessor tilesRequestAccessor = new DelegatePropertyAccessor((PropertyAccessorDelegateFactory)factory);
            OgnlRuntime.setPropertyAccessor(TilesRequestContext.class, (PropertyAccessor)tilesRequestAccessor);
            return new OGNLAttributeEvaluator();
        }
        catch (OgnlException e) {
            throw new TilesContainerFactoryException("Cannot initialize OGNL evaluator", (Exception)((Object)e));
        }
    }
}

