/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.spring;

import java.lang.reflect.Constructor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ClassReloadingBeanFactory
extends DefaultListableBeanFactory {
    protected BeanWrapper createBeanInstance(String beanName, RootBeanDefinition mbd, Object[] args) {
        Class beanClass = this.resolveBeanClass(mbd, beanName, null);
        if (mbd.getFactoryMethodName() != null) {
            return this.instantiateUsingFactoryMethod(beanName, mbd, args);
        }
        Constructor[] constructors = this.determineConstructorsFromBeanPostProcessors(beanClass, beanName);
        if (constructors != null || mbd.getResolvedAutowireMode() == 3 || mbd.hasConstructorArgumentValues() || !ObjectUtils.isEmpty((Object[])args)) {
            return this.autowireConstructor(beanName, mbd, constructors, args);
        }
        return this.instantiateBean(beanName, mbd);
    }

    protected Class resolveBeanClass(RootBeanDefinition mbd, String beanName, Class[] typesToMatch) {
        try {
            ClassLoader tempClassLoader;
            if (typesToMatch != null && (tempClassLoader = this.getTempClassLoader()) != null) {
                String className;
                if (tempClassLoader instanceof DecoratingClassLoader) {
                    DecoratingClassLoader dcl = (DecoratingClassLoader)tempClassLoader;
                    for (int i = 0; i < typesToMatch.length; ++i) {
                        dcl.excludeClass(typesToMatch[i].getName());
                    }
                }
                return (className = mbd.getBeanClassName()) != null ? ClassUtils.forName((String)className, (ClassLoader)tempClassLoader) : null;
            }
            return mbd.resolveBeanClass(this.getBeanClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), ex);
        }
        catch (LinkageError err) {
            throw new CannotLoadBeanClassException(mbd.getResourceDescription(), beanName, mbd.getBeanClassName(), err);
        }
    }
}

