/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.web.config;

import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SessionsSecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.config.AbstractShiroConfiguration;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.springframework.beans.factory.annotation.Value;

public class AbstractShiroWebConfiguration
extends AbstractShiroConfiguration {
    @Value(value="#{ @environment['shiro.sessionManager.sessionIdCookieEnabled'] ?: true }")
    protected boolean sessionIdCookieEnabled;
    @Value(value="#{ @environment['shiro.sessionManager.sessionIdUrlRewritingEnabled'] ?: true }")
    protected boolean sessionIdUrlRewritingEnabled;
    @Value(value="#{ @environment['shiro.userNativeSessionManager'] ?: false }")
    protected boolean useNativeSessionManager;
    @Value(value="#{ @environment['shiro.sessionManager.cookie.name'] ?: T(org.apache.shiro.web.servlet.ShiroHttpSession).DEFAULT_SESSION_ID_NAME }")
    protected String sessionIdCookieName;
    @Value(value="#{ @environment['shiro.sessionManager.cookie.maxAge'] ?: T(org.apache.shiro.web.servlet.SimpleCookie).DEFAULT_MAX_AGE }")
    protected int sessionIdCookieMaxAge;
    @Value(value="#{ @environment['shiro.sessionManager.cookie.domain'] ?: null }")
    protected String sessionIdCookieDomain;
    @Value(value="#{ @environment['shiro.sessionManager.cookie.path'] ?: null }")
    protected String sessionIdCookiePath;
    @Value(value="#{ @environment['shiro.sessionManager.cookie.secure'] ?: false }")
    protected boolean sessionIdCookieSecure;
    @Value(value="#{ @environment['shiro.rememberMeManager.cookie.name'] ?: T(org.apache.shiro.web.mgt.CookieRememberMeManager).DEFAULT_REMEMBER_ME_COOKIE_NAME }")
    protected String rememberMeCookieName;
    @Value(value="#{ @environment['shiro.rememberMeManager.cookie.maxAge'] ?: T(org.apache.shiro.web.servlet.Cookie).ONE_YEAR }")
    protected int rememberMeCookieMaxAge;
    @Value(value="#{ @environment['shiro.rememberMeManager.cookie.domain'] ?: null }")
    protected String rememberMeCookieDomain;
    @Value(value="#{ @environment['shiro.rememberMeManager.cookie.path'] ?: null }")
    protected String rememberMeCookiePath;
    @Value(value="#{ @environment['shiro.rememberMeManager.cookie.secure'] ?: false }")
    protected boolean rememberMeCookieSecure;

    protected SessionManager nativeSessionManager() {
        DefaultWebSessionManager webSessionManager = new DefaultWebSessionManager();
        webSessionManager.setSessionIdCookieEnabled(this.sessionIdCookieEnabled);
        webSessionManager.setSessionIdUrlRewritingEnabled(this.sessionIdUrlRewritingEnabled);
        webSessionManager.setSessionIdCookie(this.sessionCookieTemplate());
        webSessionManager.setSessionFactory(this.sessionFactory());
        webSessionManager.setSessionDAO(this.sessionDAO());
        webSessionManager.setDeleteInvalidSessions(this.sessionManagerDeleteInvalidSessions);
        return webSessionManager;
    }

    protected Cookie sessionCookieTemplate() {
        return this.buildCookie(this.sessionIdCookieName, this.sessionIdCookieMaxAge, this.sessionIdCookiePath, this.sessionIdCookieDomain, this.sessionIdCookieSecure);
    }

    protected Cookie rememberMeCookieTemplate() {
        return this.buildCookie(this.rememberMeCookieName, this.rememberMeCookieMaxAge, this.rememberMeCookiePath, this.rememberMeCookieDomain, this.rememberMeCookieSecure);
    }

    protected Cookie buildCookie(String name, int maxAge, String path, String domain, boolean secure) {
        SimpleCookie cookie = new SimpleCookie(name);
        cookie.setHttpOnly(true);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setSecure(secure);
        return cookie;
    }

    @Override
    protected SessionManager sessionManager() {
        if (this.useNativeSessionManager) {
            return this.nativeSessionManager();
        }
        return new ServletContainerSessionManager();
    }

    @Override
    protected RememberMeManager rememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie(this.rememberMeCookieTemplate());
        return cookieRememberMeManager;
    }

    @Override
    protected SubjectFactory subjectFactory() {
        return new DefaultWebSubjectFactory();
    }

    @Override
    protected SessionsSecurityManager createSecurityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setSubjectDAO(this.subjectDAO());
        securityManager.setSubjectFactory(this.subjectFactory());
        securityManager.setRememberMeManager(this.rememberMeManager());
        return securityManager;
    }
}

