/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.jndi;

import javax.naming.NamingException;
import org.apache.shiro.jndi.JndiLocator;
import org.apache.shiro.util.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiObjectFactory<T>
extends JndiLocator
implements Factory<T> {
    private String resourceName;
    private Class<? extends T> requiredType;

    @Override
    public T getInstance() {
        try {
            if (this.requiredType != null) {
                return this.requiredType.cast(this.lookup(this.resourceName, this.requiredType));
            }
            return (T)this.lookup(this.resourceName);
        }
        catch (NamingException e) {
            String typeName = this.requiredType != null ? this.requiredType.getName() : "object";
            throw new IllegalStateException("Unable to look up " + typeName + " with jndi name '" + this.resourceName + "'.", e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Class<? extends T> getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(Class<? extends T> requiredType) {
        this.requiredType = requiredType;
    }
}

