/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.ode.utils.CollectionUtils;

public class CorrelationKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _csetName;
    private String[] _keyValues;

    public CorrelationKey(String string, String[] stringArray) {
        this._csetName = string;
        this._keyValues = stringArray;
    }

    public CorrelationKey(String string) {
        int n = string.indexOf(126);
        this._csetName = string.substring(0, n == -1 ? string.length() : n);
        if (n != -1) {
            ArrayList<String> arrayList = new ArrayList<String>();
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n + 1; i < cArray.length; ++i) {
                boolean bl;
                boolean bl2 = bl = i == cArray.length - 1;
                if (cArray[i] == '~' && !bl && cArray[i + 1] == '~') {
                    stringBuffer.append(cArray[i++]);
                    continue;
                }
                if (cArray[i] == '~') {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(cArray[i]);
            }
            arrayList.add(stringBuffer.toString());
            this._keyValues = new String[arrayList.size()];
            arrayList.toArray(this._keyValues);
        } else {
            this._keyValues = new String[0];
        }
    }

    public String getCorrelationSetName() {
        return this._csetName;
    }

    public String[] getValues() {
        return this._keyValues;
    }

    public boolean isMatch(CorrelationKey[] correlationKeyArray) {
        for (CorrelationKey correlationKey : correlationKeyArray) {
            if (!correlationKey.equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        CorrelationKey correlationKey = (CorrelationKey)object;
        if (correlationKey == null || !correlationKey._csetName.equals(this._csetName) || correlationKey._keyValues.length != this._keyValues.length) {
            return false;
        }
        for (int i = 0; i < this._keyValues.length; ++i) {
            if (this._keyValues[i].equals(correlationKey._keyValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this._csetName.hashCode();
        for (String string : this._keyValues) {
            n ^= string.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{CorrelationKey ");
        stringBuffer.append("setId=");
        stringBuffer.append(this._csetName);
        stringBuffer.append(", values=");
        stringBuffer.append(CollectionUtils.makeCollection(ArrayList.class, (Object[])this._keyValues));
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toCanonicalString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._csetName);
        stringBuffer.append('~');
        for (int i = 0; i < this.getValues().length; ++i) {
            if (i != 0) {
                stringBuffer.append('~');
            }
            CorrelationKey.escapeTilde(stringBuffer, this.getValues()[i]);
        }
        return stringBuffer.toString();
    }

    static void escapeTilde(StringBuffer stringBuffer, String string) {
        char[] cArray;
        if (string == null) {
            return;
        }
        for (char c : cArray = string.toCharArray()) {
            if (c == '~') {
                stringBuffer.append("~~");
                continue;
            }
            stringBuffer.append(c);
        }
    }
}

