/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public class LightweightHttpWagon
extends StreamWagon {
    private String previousProxyExclusions;
    private String previousProxyHost;
    private String previousProxyPort;

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException {
        Repository repository = this.getRepository();
        String repositoryUrl = repository.getUrl();
        Resource resource = inputData.getResource();
        try {
            URL url = repositoryUrl.endsWith("/") ? new URL(repositoryUrl + resource.getName()) : new URL(repositoryUrl + "/" + resource.getName());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Pragma", "no-cache");
            inputData.setInputStream(urlConnection.getInputStream());
            resource.setLastModified(urlConnection.getLastModified());
            resource.setContentLength((long)urlConnection.getContentLength());
        }
        catch (MalformedURLException e) {
            throw new ResourceDoesNotExistException("Invalid repository URL", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Unable to locate resource in repository", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", (Throwable)e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new UnsupportedOperationException("PUT operation is not supported by Light Weight  HTTP wagon");
    }

    public void openConnection() throws ConnectionException, AuthenticationException {
        boolean hasAuthentication;
        this.previousProxyHost = System.getProperty("http.proxyHost");
        this.previousProxyPort = System.getProperty("http.proxyPort");
        this.previousProxyExclusions = System.getProperty("http.nonProxyHosts");
        final ProxyInfo proxyInfo = ((AbstractWagon)this).proxyInfo;
        if (proxyInfo != null) {
            System.setProperty("http.proxyHost", proxyInfo.getHost());
            System.setProperty("http.proxyPort", String.valueOf(proxyInfo.getPort()));
            if (proxyInfo.getNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", proxyInfo.getNonProxyHosts());
            }
        }
        final boolean hasProxy = proxyInfo != null && proxyInfo.getUserName() != null;
        boolean bl = hasAuthentication = ((AbstractWagon)this).authenticationInfo != null && ((AbstractWagon)this).authenticationInfo.getUserName() != null;
        if (hasProxy || hasAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyInfo.getHost()) && this.getRequestingPort() == proxyInfo.getPort()) {
                        String password = "";
                        if (proxyInfo.getPassword() != null) {
                            password = proxyInfo.getPassword();
                        }
                        return new PasswordAuthentication(proxyInfo.getUserName(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        String password = "";
                        if (((AbstractWagon)LightweightHttpWagon.this).authenticationInfo.getPassword() != null) {
                            password = ((AbstractWagon)LightweightHttpWagon.this).authenticationInfo.getPassword();
                        }
                        return new PasswordAuthentication(((AbstractWagon)LightweightHttpWagon.this).authenticationInfo.getUserName(), password.toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.previousProxyHost != null) {
            System.setProperty("http.proxyHost", this.previousProxyHost);
        }
        if (this.previousProxyPort != null) {
            System.setProperty("http.proxyPort", this.previousProxyPort);
        }
        if (this.previousProxyExclusions != null) {
            System.setProperty("http.nonProxyHosts", this.previousProxyExclusions);
        }
    }
}

