/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng.conf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.testng.conf.Configurator;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

public abstract class AbstractDirectConfigurator
implements Configurator {
    final Map setters;

    AbstractDirectConfigurator() {
        HashMap<String, Setter> options = new HashMap<String, Setter>();
        options.put("junit", new Setter("setJUnit", Boolean.class));
        options.put("threadcount", new Setter("setThreadCount", Integer.TYPE));
        options.put("usedefaultlisteners", new Setter("setUseDefaultListeners", Boolean.TYPE));
        this.setters = options;
    }

    public void configure(TestNG testng, Map options) throws TestSetFailedException {
        System.out.println("\n\n\n\nCONFIGURING TESTNG\n\n\n\n");
        String listeners = (String)options.remove("listener");
        testng.setUseDefaultListeners(false);
        this.configureInstance(testng, options);
        testng.setListenerClasses(AbstractDirectConfigurator.loadListenerClasses(listeners));
    }

    public void configure(XmlSuite suite, Map options) throws TestSetFailedException {
        Map filtered = this.filterForSuite(options);
        this.configureInstance(suite, filtered);
    }

    protected Map filterForSuite(Map options) {
        HashMap result = new HashMap();
        this.addPropIfNotNull(options, result, "parallel");
        this.addPropIfNotNull(options, result, "threadcount");
        return result;
    }

    private void addPropIfNotNull(Map options, Map result, String prop) {
        if (options.containsKey(prop)) {
            result.put(prop, options.get(prop));
        }
    }

    private void configureInstance(Object testngInstance, Map options) {
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            Setter setter = (Setter)this.setters.get(key);
            if (setter == null) continue;
            try {
                setter.invoke(testngInstance, val);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot set option " + key + " with value " + val, ex);
            }
        }
    }

    public static List loadListenerClasses(String listenerClasses) throws TestSetFailedException {
        if (listenerClasses == null || "".equals(listenerClasses.trim())) {
            return new ArrayList();
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        String[] classNames = listenerClasses.split("\\s*,\\s*(\\r?\\n)?\\s*");
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            Class clazz = AbstractDirectConfigurator.loadClass(className);
            classes.add(clazz);
        }
        return classes;
    }

    public static Class loadClass(String className) throws TestSetFailedException {
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            throw new TestSetFailedException("Cannot find listener class " + className, (Throwable)ex);
        }
    }

    public static final class Setter {
        private final String setterName;
        private final Class paramClass;

        public Setter(String name, Class clazz) {
            this.setterName = name;
            this.paramClass = clazz;
        }

        public void invoke(Object target, Object value) throws Exception {
            Method setter = target.getClass().getMethod(this.setterName, this.paramClass);
            if (setter != null) {
                setter.invoke(target, this.convertValue(value));
            }
        }

        Object convertValue(Object value) {
            if (value == null) {
                return value;
            }
            if (this.paramClass.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (Boolean.class.equals((Object)this.paramClass) || Boolean.TYPE.equals(this.paramClass)) {
                return Boolean.valueOf(value.toString());
            }
            if (Integer.class.equals((Object)this.paramClass) || Integer.TYPE.equals(this.paramClass)) {
                return new Integer(value.toString());
            }
            return value;
        }
    }
}

