/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.testng.TestNGDirectoryTestSuite;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testng.TestNgTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNGXmlTestSuite
implements TestNgTestSuite {
    private final List suiteFiles;
    private List<String> suiteFilePaths;
    private final String testSourceDirectory;
    private final Map options;
    private final File reportsDirectory;
    private Map<File, String> testSets;

    public TestNGXmlTestSuite(List<File> suiteFiles, String testSourceDirectory, Properties confOptions, File reportsDirectory) {
        this.suiteFiles = suiteFiles;
        this.options = confOptions;
        this.testSourceDirectory = testSourceDirectory;
        this.reportsDirectory = reportsDirectory;
    }

    public void execute(ReporterFactory reporterManagerFactory) throws ReporterException, TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        RunListener reporter = reporterManagerFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        TestNGDirectoryTestSuite.startTestSuite(reporter, this);
        TestNGExecutor.run(this.suiteFilePaths, this.testSourceDirectory, this.options, reporter, this, this.reportsDirectory);
        TestNGDirectoryTestSuite.finishTestSuite(reporter, this);
    }

    @Override
    public void execute(String testSetName, ReporterFactory reporterManagerFactory) throws TestSetFailedException {
        throw new TestSetFailedException("Cannot run individual test when suite files are specified");
    }

    @Override
    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        if (this.suiteFiles == null) {
            throw new IllegalStateException("No suite files were specified");
        }
        this.testSets = new HashMap<File, String>();
        this.suiteFilePaths = new ArrayList<String>();
        for (Object suiteFile : this.suiteFiles) {
            File file = (File)suiteFile;
            if (!file.exists() || !file.isFile()) {
                throw new TestSetFailedException("Suite file " + file + " is not a valid file");
            }
            this.testSets.put(file, file.getAbsolutePath());
            this.suiteFilePaths.add(file.getAbsolutePath());
        }
        return this.testSets;
    }

    public String getSuiteName() {
        String result = (String)this.options.get("suitename");
        if (result == null) {
            result = "TestSuite";
        }
        return result;
    }
}

