/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.exposers;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.identification.JarIdentification;
import org.apache.maven.shared.jar.identification.JarIdentificationExposer;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.apache.maven.shared.jar.identification.repository.RepositoryHashSearch;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class RepositorySearchExposer
extends AbstractLogEnabled
implements JarIdentificationExposer {
    private RepositoryHashSearch repositoryHashSearch;
    private JarHashAnalyzer fileHashAnalyzer;
    private JarHashAnalyzer bytecodeHashAnalyzer;

    public void expose(JarIdentification identification, JarAnalyzer jarAnalyzer) {
        String bytecodehash;
        ArrayList repohits = new ArrayList();
        String hash = this.fileHashAnalyzer.computeHash(jarAnalyzer);
        if (hash != null) {
            repohits.addAll(this.repositoryHashSearch.searchFileHash(hash));
        }
        if ((bytecodehash = this.bytecodeHashAnalyzer.computeHash(jarAnalyzer)) != null) {
            repohits.addAll(this.repositoryHashSearch.searchBytecodeHash(bytecodehash));
        }
        if (!repohits.isEmpty()) {
            Iterator it = repohits.iterator();
            while (it.hasNext()) {
                Artifact artifact = (Artifact)it.next();
                identification.addAndSetGroupId(artifact.getGroupId());
                identification.addAndSetArtifactId(artifact.getArtifactId());
                identification.addAndSetVersion(artifact.getVersion());
            }
        }
    }

    public void setRepositoryHashSearch(RepositoryHashSearch repo) {
        this.repositoryHashSearch = repo;
    }

    public void setFileHashAnalyzer(JarHashAnalyzer fileHashAnalyzer) {
        this.fileHashAnalyzer = fileHashAnalyzer;
    }

    public void setBytecodeHashAnalyzer(JarHashAnalyzer bytecodeHashAnalyzer) {
        this.bytecodeHashAnalyzer = bytecodeHashAnalyzer;
    }
}

