/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.project.install.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.project.NoFileAssignedException;
import org.apache.maven.shared.project.install.ProjectInstaller;
import org.apache.maven.shared.project.install.ProjectInstallerRequest;
import org.apache.maven.shared.project.install.internal.DualDigester;
import org.apache.maven.shared.repository.RepositoryManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ProjectInstaller.class)
public class DefaultProjectInstaller
implements ProjectInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectInstaller.class);
    @Requirement
    private ArtifactInstaller installer;
    @Requirement
    private RepositoryManager repositoryManager;
    private final DualDigester digester = new DualDigester();

    @Override
    public void install(ProjectBuildingRequest buildingRequest, ProjectInstallerRequest request) throws IOException, ArtifactInstallerException, NoFileAssignedException {
        MavenProject project = request.getProject();
        boolean createChecksum = request.isCreateChecksum();
        boolean updateReleaseInfo = request.isUpdateReleaseInfo();
        Artifact artifact = project.getArtifact();
        String packaging = project.getPackaging();
        File pomFile = project.getFile();
        List attachedArtifacts = project.getAttachedArtifacts();
        boolean isPomArtifact = "pom".equals(packaging);
        if (updateReleaseInfo) {
            artifact.setRelease(true);
        }
        LinkedHashSet<File> metadataFiles = new LinkedHashSet<File>();
        if (isPomArtifact) {
            if (pomFile != null) {
                this.installer.install(buildingRequest, Collections.singletonList(new ProjectArtifact(project)));
                this.installChecksums(buildingRequest, artifact, createChecksum);
                this.addMetaDataFilesForArtifact(buildingRequest, artifact, metadataFiles, createChecksum);
            }
        } else {
            File file;
            if (pomFile != null) {
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
            }
            if ((file = artifact.getFile()) != null && file.isFile()) {
                this.installer.install(buildingRequest, Collections.singletonList(artifact));
                this.installChecksums(buildingRequest, artifact, createChecksum);
                this.addMetaDataFilesForArtifact(buildingRequest, artifact, metadataFiles, createChecksum);
            } else {
                if (!attachedArtifacts.isEmpty()) {
                    throw new NoFileAssignedException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new NoFileAssignedException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        for (Artifact attached : attachedArtifacts) {
            this.installer.install(buildingRequest, Collections.singletonList(attached));
            this.installChecksums(buildingRequest, attached, createChecksum);
            this.addMetaDataFilesForArtifact(buildingRequest, attached, metadataFiles, createChecksum);
        }
        this.installChecksums(metadataFiles);
    }

    private void installChecksums(ProjectBuildingRequest buildingRequest, Artifact artifact, boolean createChecksum) throws IOException {
        if (!createChecksum) {
            return;
        }
        File artifactFile = this.getLocalRepoFile(buildingRequest, artifact);
        this.installChecksums(artifactFile);
    }

    private void addMetaDataFilesForArtifact(ProjectBuildingRequest buildingRequest, Artifact artifact, Collection<File> targetMetadataFiles, boolean createChecksum) {
        if (!createChecksum) {
            return;
        }
        Collection metadatas = artifact.getMetadataList();
        if (metadatas != null) {
            for (ArtifactMetadata metadata : metadatas) {
                File metadataFile = this.getLocalRepoFile(buildingRequest, metadata);
                targetMetadataFiles.add(metadataFile);
            }
        }
    }

    private void installChecksums(Collection<File> metadataFiles) throws IOException {
        for (File metadataFile : metadataFiles) {
            this.installChecksums(metadataFile);
        }
    }

    private void installChecksums(File installedFile) throws IOException {
        boolean signatureFile = installedFile.getName().endsWith(".asc");
        if (installedFile.isFile() && !signatureFile) {
            LOGGER.debug("Calculating checksums for " + installedFile);
            this.digester.calculate(installedFile);
            this.installChecksum(installedFile, ".md5", this.digester.getMd5());
            this.installChecksum(installedFile, ".sha1", this.digester.getSha1());
        }
    }

    private void installChecksum(File installedFile, String ext, String checksum) throws IOException {
        File checksumFile = new File(installedFile.getAbsolutePath() + ext);
        LOGGER.debug("Installing checksum to " + checksumFile);
        try {
            checksumFile.getParentFile().mkdirs();
            FileUtils.fileWrite((String)checksumFile.getAbsolutePath(), (String)"UTF-8", (String)checksum);
        }
        catch (IOException e) {
            throw new IOException("Failed to install checksum to " + checksumFile, e);
        }
    }

    private File getLocalRepoFile(ProjectBuildingRequest buildingRequest, Artifact artifact) {
        String path = this.repositoryManager.getPathForLocalArtifact(buildingRequest, artifact);
        return new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), path);
    }

    private File getLocalRepoFile(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        String path = this.repositoryManager.getPathForLocalMetadata(buildingRequest, metadata);
        return new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), path);
    }
}

