/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.update;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

public abstract class UpdateCommandTckTest
extends ScmTckTestCase {
    private void commit(File workingDirectory, ScmRepository repository) throws Exception {
        CheckInScmResult result = this.getScmManager().checkIn(repository, new ScmFileSet(workingDirectory), "No msg");
        UpdateCommandTckTest.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        List committedFiles = result.getCheckedInFiles();
        UpdateCommandTckTest.assertEquals((String)("Expected 3 files in the committed files list:\n  " + StringUtils.join(committedFiles.iterator(), (String)"\n  ")), (int)3, (int)committedFiles.size());
    }

    public void testUpdateCommand() throws Exception {
        ScmRepository repository = this.makeScmRepository(this.getScmUrl());
        this.checkOut(this.getUpdatingCopy(), repository);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/readme.txt", "changed readme.txt");
        ScmTestCase.makeFile(this.getWorkingCopy(), "/project.xml", "changed project.xml");
        this.addToWorkingTree(this.getWorkingCopy(), new File("project.xml"), repository);
        ScmTestCase.makeDirectory(this.getWorkingCopy(), "/src/test/java/org");
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/test/java/org"), repository);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/src/main/java/org/Foo.java");
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/main/java/org"), repository);
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/main/java/org/Foo.java"), repository);
        ScmManager scmManager = this.getScmManager();
        Date lastUpdate = new Date(System.currentTimeMillis());
        Thread.sleep(1000L);
        this.commit(this.getWorkingCopy(), repository);
        UpdateScmResult result = scmManager.update(repository, new ScmFileSet(this.getUpdatingCopy()), lastUpdate);
        UpdateCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        List updatedFiles = result.getUpdatedFiles();
        List changedFiles = result.getChanges();
        UpdateCommandTckTest.assertEquals((String)("Expected 3 files in the updated files list " + updatedFiles), (int)3, (int)updatedFiles.size());
        UpdateCommandTckTest.assertNotNull((String)"The changed files list is null", (Object)changedFiles);
        UpdateCommandTckTest.assertFalse((String)"The changed files list is empty", (boolean)changedFiles.isEmpty());
        Iterator i = changedFiles.iterator();
        while (i.hasNext()) {
            ChangeSet changeSet = (ChangeSet)i.next();
            System.out.println(changeSet.toXML());
        }
        Iterator files = new TreeSet(updatedFiles).iterator();
        ScmFile file = (ScmFile)files.next();
        this.assertPath("/src/main/java/org/Foo.java", file.getPath());
        UpdateCommandTckTest.assertTrue((file.getStatus().isUpdate() || file.getStatus() == ScmFileStatus.ADDED ? 1 : 0) != 0);
        file = (ScmFile)files.next();
        this.assertPath("/readme.txt", file.getPath());
        UpdateCommandTckTest.assertTrue((boolean)file.getStatus().isUpdate());
        file = (ScmFile)files.next();
        this.assertPath("/project.xml", file.getPath());
        UpdateCommandTckTest.assertTrue((file.getStatus().isUpdate() || file.getStatus() == ScmFileStatus.ADDED ? 1 : 0) != 0);
    }
}

