/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.diff;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public abstract class DiffCommandTckTest
extends ScmTckTestCase {
    public void testDiffCommand() throws Exception {
        ScmRepository repository = this.getScmRepository();
        ScmTestCase.makeFile(this.getWorkingCopy(), "/readme.txt", "changed readme.txt");
        ScmTestCase.makeFile(this.getWorkingCopy(), "/project.xml", "changed project.xml");
        this.addToWorkingTree(this.getWorkingCopy(), new File("project.xml"), repository);
        ScmTestCase.makeDirectory(this.getWorkingCopy(), "/src/test/java/org");
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/test/java/org"), repository);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/src/main/java/org/Foo.java");
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/main/java/org"), repository);
        this.addToWorkingTree(this.getWorkingCopy(), new File("src/main/java/org/Foo.java"), repository);
        ScmProvider provider = this.getScmManager().getProviderByUrl(this.getScmUrl());
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        DiffScmResult result = provider.diff(repository, fileSet, null, (ScmVersion)null);
        DiffCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        List changedFiles = result.getChangedFiles();
        Map differences = result.getDifferences();
        DiffCommandTckTest.assertEquals((String)("Expected 3 files in the changed files list " + changedFiles), (int)3, (int)changedFiles.size());
        DiffCommandTckTest.assertEquals((String)("Expected 3 files in the differences list " + differences), (int)3, (int)differences.size());
        Iterator files = new TreeSet(changedFiles).iterator();
        ScmFile file = (ScmFile)files.next();
        this.assertPath("/src/main/java/org/Foo.java", file.getPath());
        DiffCommandTckTest.assertTrue((boolean)file.getStatus().isDiff());
        String postRangeStr = "+/src/main/java/org/Foo.java\n\\ No newline at end of file\n";
        String actualStr = differences.get(file.getPath()).toString();
        DiffCommandTckTest.assertTrue((boolean)actualStr.endsWith(postRangeStr));
        file = (ScmFile)files.next();
        this.assertPath("/readme.txt", file.getPath());
        DiffCommandTckTest.assertTrue((boolean)file.getStatus().isDiff());
        postRangeStr = "-/readme.txt\n\\ No newline at end of file\n+changed readme.txt\n\\ No newline at end of file\n";
        actualStr = differences.get(file.getPath()).toString();
        DiffCommandTckTest.assertTrue((boolean)actualStr.endsWith(postRangeStr));
        file = (ScmFile)files.next();
        this.assertPath("/project.xml", file.getPath());
        postRangeStr = "+changed project.xml\n\\ No newline at end of file\n";
        actualStr = differences.get(file.getPath()).toString();
        DiffCommandTckTest.assertTrue((boolean)actualStr.endsWith(postRangeStr));
        DiffCommandTckTest.assertTrue((boolean)file.getStatus().isDiff());
    }
}

