/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.checkin;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.codehaus.plexus.util.FileUtils;

public abstract class CheckInCommandTckTest
extends ScmTckTestCase {
    public void testCheckInCommandTest() throws Exception {
        File fooJava = new File(this.getWorkingCopy(), "src/main/java/Foo.java");
        File barJava = new File(this.getWorkingCopy(), "src/main/java/Bar.java");
        File readmeTxt = new File(this.getWorkingCopy(), "readme.txt");
        CheckInCommandTckTest.assertFalse((String)"check Foo.java doesn't yet exist", (boolean)fooJava.canRead());
        CheckInCommandTckTest.assertFalse((String)"check Bar.java doesn't yet exist", (boolean)barJava.canRead());
        CheckInCommandTckTest.assertTrue((String)"check can read readme.txt", (boolean)readmeTxt.canRead());
        this.createFooJava(fooJava);
        this.createBarJava(barJava);
        this.changeReadmeTxt(readmeTxt);
        AddScmResult addResult = this.getScmManager().add(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy(), "src/main/java/Foo.java", null));
        this.assertResultIsSuccess((ScmResult)addResult);
        CheckInScmResult result = this.getScmManager().checkIn(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy()), "Commit message");
        this.assertResultIsSuccess((ScmResult)result);
        List files = result.getCheckedInFiles();
        CheckInCommandTckTest.assertNotNull((Object)files);
        CheckInCommandTckTest.assertEquals((int)2, (int)files.size());
        ScmFile file1 = (ScmFile)files.get(0);
        CheckInCommandTckTest.assertEquals((Object)ScmFileStatus.CHECKED_IN, (Object)file1.getStatus());
        this.assertPath("/test-repo/check-in/Foo.java", file1.getPath());
        ScmFile file2 = (ScmFile)files.get(1);
        CheckInCommandTckTest.assertEquals((Object)ScmFileStatus.CHECKED_IN, (Object)file2.getStatus());
        this.assertPath("/test-repo/check-in/readme.txt", file2.getPath());
        CheckOutScmResult checkoutResult = this.getScmManager().checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        fooJava = new File(this.getAssertionCopy(), "src/main/java/Foo.java");
        barJava = new File(this.getAssertionCopy(), "src/main/java/Bar.java");
        readmeTxt = new File(this.getAssertionCopy(), "readme.txt");
        CheckInCommandTckTest.assertTrue((String)"check can read Foo.java", (boolean)fooJava.canRead());
        CheckInCommandTckTest.assertFalse((String)"check Bar.java doesn't exist", (boolean)barJava.canRead());
        CheckInCommandTckTest.assertTrue((String)"check can read readme.txt", (boolean)readmeTxt.canRead());
        CheckInCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"changed file", (String)FileUtils.fileRead((File)readmeTxt));
    }

    public void testCheckInCommandPartialFileset() throws Exception {
        File fooJava = new File(this.getWorkingCopy(), "src/main/java/Foo.java");
        File barJava = new File(this.getWorkingCopy(), "src/main/java/Bar.java");
        File readmeTxt = new File(this.getWorkingCopy(), "readme.txt");
        CheckInCommandTckTest.assertFalse((String)"check Foo.java doesn't yet exist", (boolean)fooJava.canRead());
        CheckInCommandTckTest.assertFalse((String)"check Bar.java doesn't yet exist", (boolean)barJava.canRead());
        CheckInCommandTckTest.assertTrue((String)"check can read readme.txt", (boolean)readmeTxt.canRead());
        this.createFooJava(fooJava);
        this.createBarJava(barJava);
        this.changeReadmeTxt(readmeTxt);
        AddScmResult addResult = this.getScmManager().getProviderByUrl(this.getScmUrl()).add(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy(), "src/main/java/Foo.java", null));
        this.assertResultIsSuccess((ScmResult)addResult);
        CheckInScmResult result = this.getScmManager().checkIn(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy(), "**/Foo.java", null), "Commit message");
        this.assertResultIsSuccess((ScmResult)result);
        List files = result.getCheckedInFiles();
        CheckInCommandTckTest.assertNotNull((Object)files);
        CheckInCommandTckTest.assertEquals((int)1, (int)files.size());
        ScmFile file1 = (ScmFile)files.get(0);
        CheckInCommandTckTest.assertEquals((Object)ScmFileStatus.CHECKED_IN, (Object)file1.getStatus());
        this.assertPath("/test-repo/check-in/Foo.java", file1.getPath());
        CheckOutScmResult checkoutResult = this.getScmManager().checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        fooJava = new File(this.getAssertionCopy(), "src/main/java/Foo.java");
        barJava = new File(this.getAssertionCopy(), "src/main/java/Bar.java");
        readmeTxt = new File(this.getAssertionCopy(), "readme.txt");
        CheckInCommandTckTest.assertTrue((String)"check can read Foo.java", (boolean)fooJava.canRead());
        CheckInCommandTckTest.assertFalse((String)"check Bar.java doesn't exist", (boolean)barJava.canRead());
        CheckInCommandTckTest.assertTrue((String)"check can read readme.txt", (boolean)readmeTxt.canRead());
        CheckInCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"/readme.txt", (String)FileUtils.fileRead((File)readmeTxt));
    }

    private void createFooJava(File fooJava) throws Exception {
        FileWriter output = new FileWriter(fooJava);
        PrintWriter printer = new PrintWriter(output);
        printer.println("public class Foo");
        printer.println("{");
        printer.println("    public void foo()");
        printer.println("    {");
        printer.println("        int i = 10;");
        printer.println("    }");
        printer.println("}");
        printer.close();
        output.close();
    }

    private void createBarJava(File barJava) throws Exception {
        FileWriter output = new FileWriter(barJava);
        PrintWriter printer = new PrintWriter(output);
        printer.println("public class Bar");
        printer.println("{");
        printer.println("    public int bar()");
        printer.println("    {");
        printer.println("        return 20;");
        printer.println("    }");
        printer.println("}");
        printer.close();
        output.close();
    }

    private void changeReadmeTxt(File readmeTxt) throws Exception {
        FileWriter output = new FileWriter(readmeTxt);
        output.write("changed file");
        output.close();
    }
}

