/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public abstract class ScmTckTestCase
extends ScmTestCase {
    private ScmRepository scmRepository;
    private List scmFileNames;

    public abstract String getScmUrl() throws Exception;

    protected List getScmFileNames() {
        return this.scmFileNames;
    }

    public abstract void initRepo() throws Exception;

    protected void setUp() throws Exception {
        super.setUp();
        this.scmRepository = null;
        this.initRepo();
        this.checkOut(this.getWorkingCopy(), this.getScmRepository());
        this.scmFileNames = new ArrayList(4);
        this.scmFileNames.add("/pom.xml");
        this.scmFileNames.add("/readme.txt");
        this.scmFileNames.add("/src/main/java/Application.java");
        this.scmFileNames.add("/src/test/java/Test.java");
        Iterator it = this.getScmFileNames().iterator();
        while (it.hasNext()) {
            this.assertFile(this.getWorkingCopy(), (String)it.next());
        }
    }

    protected ScmRepository getScmRepository() throws Exception {
        if (this.scmRepository == null) {
            this.scmRepository = this.getScmManager().makeScmRepository(this.getScmUrl());
        }
        return this.scmRepository;
    }

    protected CheckOutScmResult checkOut(File workingDirectory, ScmRepository repository) throws Exception {
        CheckOutScmResult result = this.getScmManager().getProviderByUrl(this.getScmUrl()).checkOut(repository, new ScmFileSet(workingDirectory), (ScmVersion)null);
        ScmTckTestCase.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        return result;
    }

    protected void addToWorkingTree(File workingDirectory, File file, ScmRepository repository) throws Exception {
        ScmProvider provider = this.getScmManager().getProviderByUrl(this.getScmUrl());
        AddScmResult result = provider.add(repository, new ScmFileSet(workingDirectory, file));
        ScmTckTestCase.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        List addedFiles = result.getAddedFiles();
        if (new File(workingDirectory, file.getPath()).isFile()) {
            ScmTckTestCase.assertEquals((String)("Expected 1 file in the added files list " + addedFiles), (int)1, (int)addedFiles.size());
        }
    }
}

