/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.diff;

import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.diff.StarteamDiffConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamDiffCommand
extends AbstractDiffCommand
implements StarteamCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion) throws ScmException {
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support diff command on a subsets of a directory");
        }
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamDiffConsumer consumer = new StarteamDiffConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cl = StarteamDiffCommand.createCommandLine(repository, fileSet, startVersion, endVersion);
        int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
        if (exitCode != 0) {
            return new DiffScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
        }
        return new DiffScmResult(cl.toString(), consumer.getChangedFiles(), consumer.getDifferences(), consumer.getPatch());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, ScmFileSet workingDirectory, ScmVersion startLabel, ScmVersion endLabel) throws ScmException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-filter");
        args.add("M");
        if (startLabel != null && StringUtils.isNotEmpty((String)startLabel.getName())) {
            args.add("-vl");
            args.add(startLabel.getName());
        }
        if (endLabel != null && StringUtils.isNotEmpty((String)endLabel.getName())) {
            args.add("-vl");
            args.add(endLabel.getName());
        }
        if (endLabel != null && (startLabel == null || StringUtils.isEmpty((String)startLabel.getName()))) {
            throw new ScmException("Missing start label.");
        }
        StarteamCommandLineUtils.addEOLOption(args);
        return StarteamCommandLineUtils.createStarteamCommandLine("diff", args, workingDirectory, repo);
    }
}

