/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class StarteamCheckOutConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private String workingDirectory;
    private String currentDir = "";
    private List files = new ArrayList();
    private static final String DIR_MARKER = "(working dir: ";
    private static final String CHECKOUT_MARKER = ": checked out";
    private static final String SKIPPED_MARKER = ": skipped";

    public StarteamCheckOutConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory.getPath().replace('\\', '/');
    }

    public void consumeLine(String line) {
        this.logger.debug(line);
        int pos = 0;
        pos = line.indexOf(CHECKOUT_MARKER);
        if (pos != -1) {
            this.processCheckedOutFile(line, pos);
        } else {
            pos = line.indexOf(DIR_MARKER);
            if (pos != -1) {
                this.processDirectory(line, pos);
            } else {
                pos = line.indexOf(CHECKOUT_MARKER);
                if (pos != -1) {
                    this.processCheckedOutFile(line, pos);
                } else {
                    pos = line.indexOf(SKIPPED_MARKER);
                    if (pos != -1) {
                        this.processSkippedFile(line, pos);
                    } else {
                        this.logger.warn("Unknown checkout ouput: " + line);
                    }
                }
            }
        }
    }

    public List getCheckedOutFiles() {
        return this.files;
    }

    private void processDirectory(String line, int pos) {
        String dirPath = line.substring(pos + DIR_MARKER.length(), line.length() - 1).replace('\\', '/');
        try {
            this.currentDir = StarteamCommandLineUtils.getRelativeChildDirectory(this.workingDirectory, dirPath);
        }
        catch (IllegalStateException e) {
            String error = "Working and checkout directories are not on the same tree";
            this.logger.error(error);
            this.logger.error("Working directory: " + this.workingDirectory);
            this.logger.error("Checked out directory: " + dirPath);
            throw new IllegalStateException(error);
        }
    }

    private void processCheckedOutFile(String line, int pos) {
        String checkedOutFilePath = this.currentDir + "/" + line.substring(0, pos);
        this.files.add(new ScmFile(checkedOutFilePath, ScmFileStatus.CHECKED_OUT));
        this.logger.info("Checked out: " + checkedOutFilePath);
    }

    private void processSkippedFile(String line, int pos) {
        String skippedFilePath = this.currentDir + "/" + line.substring(0, pos);
        this.logger.debug("Skipped: " + skippedFilePath);
    }
}

