/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.checkout;

import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.checkout.JazzCheckOutConsumer;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzCheckOutCommand
extends AbstractCheckOutCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion, boolean recursive) throws ScmException {
        ErrorConsumer errConsumer;
        JazzCheckOutConsumer checkoutConsumer;
        JazzScmProviderRepository jazzRepo;
        JazzScmCommand checkoutCmd;
        int status;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing checkout command...");
        }
        if ((status = (checkoutCmd = this.createJazzLoadCommand(jazzRepo = (JazzScmProviderRepository)repo, fileSet, scmVersion)).execute((StreamConsumer)(checkoutConsumer = new JazzCheckOutConsumer(repo, this.getLogger())), errConsumer = new ErrorConsumer(this.getLogger()))) != 0) {
            return new CheckOutScmResult(checkoutCmd.getCommandString(), "Error code for Jazz SCM checkout (load) command - " + status, errConsumer.getOutput(), false);
        }
        return new CheckOutScmResult(checkoutCmd.getCommandString(), checkoutConsumer.getCheckedOutFiles());
    }

    public JazzScmCommand createJazzLoadCommand(JazzScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion) {
        JazzScmCommand command = new JazzScmCommand("load", "--force", (ScmProviderRepository)repo, fileSet, this.getLogger());
        if (fileSet != null) {
            command.addArgument("--dir");
            command.addArgument(fileSet.getBasedir().getAbsolutePath());
        }
        String workspace = repo.getRepositoryWorkspace();
        if (scmVersion != null && StringUtils.isNotEmpty((String)scmVersion.getName())) {
            if (scmVersion instanceof ScmTag) {
                workspace = scmVersion.getName();
            } else if (scmVersion instanceof ScmBranch) {
                workspace = scmVersion.getName();
            }
        }
        command.addArgument(workspace);
        return command;
    }
}

