/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitAddCommand
extends AbstractAddCommand
implements GitCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitStatusConsumer statusConsumer;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to add");
        }
        AddScmResult result = this.executeAddFileSet(fileSet);
        if (result != null) {
            return result;
        }
        Commandline clStatus = GitStatusCommand.createCommandLine(repository, fileSet);
        int exitCode = GitCommandLineUtils.execute(clStatus, statusConsumer = new GitStatusConsumer(this.getLogger(), fileSet.getBasedir()), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0 && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("nothing added to commit but untracked files present (use \"git add\" to track)");
        }
        ArrayList<ScmFile> changedFiles = new ArrayList<ScmFile>();
        for (ScmFile scmfile : statusConsumer.getChangedFiles()) {
            for (File f : fileSet.getFileList()) {
                if (!FilenameUtils.separatorsToUnix((String)f.getPath()).equals(scmfile.getPath())) continue;
                changedFiles.add(scmfile);
            }
        }
        Commandline cl = GitAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        return new AddScmResult(cl.toString(), changedFiles);
    }

    public static Commandline createCommandLine(File workingDirectory, List<File> files) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "add");
        cl.createArg().setValue("--");
        GitCommandLineUtils.addTarget(cl, files);
        return cl;
    }

    private AddScmResult executeAddFileSet(ScmFileSet fileSet) throws ScmException {
        File workingDirectory = fileSet.getBasedir();
        List files = fileSet.getFileList();
        if (Os.isFamily((String)"windows")) {
            for (File file : files) {
                AddScmResult result = this.executeAddFiles(workingDirectory, Collections.singletonList(file));
                if (result == null) continue;
                return result;
            }
        } else {
            AddScmResult result = this.executeAddFiles(workingDirectory, files);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    private AddScmResult executeAddFiles(File workingDirectory, List<File> files) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        CommandLineUtils.StringStreamConsumer stdout;
        Commandline cl = GitAddCommand.createCommandLine(workingDirectory, files);
        int exitCode = GitCommandLineUtils.execute(cl, stdout = new CommandLineUtils.StringStreamConsumer(), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new AddScmResult(cl.toString(), "The git-add command failed.", stderr.getOutput(), false);
        }
        return null;
    }
}

