/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.diff;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.diff.AbstractDiffCommand;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsDiffCommand
extends AbstractDiffCommand
implements CvsCommand {
    protected DiffScmResult executeDiffCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion startRevision, ScmVersion endRevision) throws ScmException {
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("diff", repository, fileSet);
        cl.createArgument().setValue("-u");
        if (this.isSupportNewFileParameter()) {
            cl.createArgument().setValue("-N");
        }
        if (startRevision != null && StringUtils.isNotEmpty((String)startRevision.getName())) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(startRevision.getName());
        }
        if (endRevision != null && StringUtils.isNotEmpty((String)endRevision.getName())) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(endRevision.getName());
        }
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        return this.executeCvsCommand(cl);
    }

    protected abstract DiffScmResult executeCvsCommand(Commandline var1) throws ScmException;

    protected boolean isSupportNewFileParameter() {
        return true;
    }
}

