/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class DefaultReleaseManager
extends AbstractLogEnabled
implements ReleaseManager {
    private List preparePhases;
    private List performPhases;
    private List rollbackPhases;
    private List branchPhases;
    private List updateVersionsPhases;
    private Map releasePhases;
    private ReleaseDescriptorStore configStore;
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private static final int PHASE_SKIP = 0;
    private static final int PHASE_START = 1;
    private static final int PHASE_END = 2;
    private static final int GOAL_START = 11;
    private static final int GOAL_END = 12;
    private static final int ERROR = 99;

    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, true, false, null);
    }

    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean resume, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleaseResult prepareWithResult(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) {
        ReleaseResult result = new ReleaseResult();
        result.setStartTime(System.currentTimeMillis());
        try {
            this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, listener, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException e) {
            this.captureException(result, listener, e);
        }
        catch (ReleaseFailureException e) {
            this.captureException(result, listener, e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    public void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, releaseEnvironment, reactorProjects, resume, dryRun, listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(listener, "prepare", 11);
        ReleaseDescriptor config = resume ? this.loadReleaseDescriptor(releaseDescriptor, listener) : releaseDescriptor;
        String completedPhase = config.getCompletedPhase();
        int index = this.preparePhases.indexOf(completedPhase);
        for (int idx = 0; idx <= index; ++idx) {
            this.updateListener(listener, this.preparePhases.get(idx).toString(), 0);
        }
        if (index == this.preparePhases.size() - 1) {
            this.logInfo(result, "Release preparation already completed. You can now continue with release:perform, or start again using the -Dresume=false flag");
        } else if (index >= 0) {
            this.logInfo(result, "Resuming release from phase '" + this.preparePhases.get(index + 1) + "'");
        }
        for (int i = index + 1; i < this.preparePhases.size(); ++i) {
            String name = (String)this.preparePhases.get(i);
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(listener, name, 1);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = dryRun ? phase.simulate(config, releaseEnvironment, reactorProjects) : phase.execute(config, releaseEnvironment, reactorProjects);
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.getOutputBuffer().append(phaseResult.getOutput());
                }
            }
            config.setCompletedPhase(name);
            try {
                this.configStore.write(config);
            }
            catch (ReleaseDescriptorStoreException e) {
                throw new ReleaseExecutionException("Error writing release properties after completing phase", e);
            }
            this.updateListener(listener, name, 2);
        }
        this.updateListener(listener, "prepare", 12);
    }

    public void rollback(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, releaseEnvironment, reactorProjects, null);
    }

    public void rollback(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(listener, "rollback", 11);
        releaseDescriptor = this.loadReleaseDescriptor(releaseDescriptor, null);
        Iterator phases = this.rollbackPhases.iterator();
        while (phases.hasNext()) {
            String name = (String)phases.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(listener, name, 1);
            phase.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
            this.updateListener(listener, name, 2);
        }
        this.clean(releaseDescriptor, listener, reactorProjects);
        this.updateListener(listener, "prepare", 12);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, null, true);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, null, clean);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, true);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseManagerListener listener, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, new ReleaseResult(), clean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReleaseResult performWithResult(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseManagerListener listener) {
        ReleaseResult result = new ReleaseResult();
        try {
            result.setStartTime(System.currentTimeMillis());
            this.perform(releaseDescriptor, releaseEnvironment, reactorProjects, listener, result, true);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException e) {
            this.captureException(result, listener, e);
        }
        catch (ReleaseFailureException e) {
            this.captureException(result, listener, e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    private void perform(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, ReleaseManagerListener listener, ReleaseResult result, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(listener, "perform", 11);
        releaseDescriptor = this.loadReleaseDescriptor(releaseDescriptor, listener);
        ReleaseResult phaseResult = null;
        Iterator phases = this.performPhases.iterator();
        while (phases.hasNext()) {
            String name = (String)phases.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(listener, name, 1);
            phaseResult = phase.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
            result.getOutputBuffer().append(phaseResult.getOutput());
            this.updateListener(listener, name, 2);
        }
        if (clean) {
            this.clean(releaseDescriptor, listener, reactorProjects);
        }
        this.updateListener(listener, "perform", 12);
    }

    public void branch(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, releaseEnvironment, reactorProjects, dryRun, null);
    }

    public void branch(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.updateListener(listener, "branch", 11);
        releaseDescriptor = this.loadReleaseDescriptor(releaseDescriptor, listener);
        Iterator phases = this.branchPhases.iterator();
        while (phases.hasNext()) {
            String name = (String)phases.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(listener, name, 1);
            if (dryRun) {
                phase.simulate(releaseDescriptor, releaseEnvironment, reactorProjects);
            } else {
                phase.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
            }
            this.updateListener(listener, name, 2);
        }
        if (!dryRun) {
            this.clean(releaseDescriptor, listener, reactorProjects);
        }
        this.updateListener(listener, "branch", 12);
    }

    public void updateVersions(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseManagerListener listener = null;
        this.updateListener(listener, "updateVersions", 11);
        releaseDescriptor = this.loadReleaseDescriptor(releaseDescriptor, listener);
        Iterator phases = this.updateVersionsPhases.iterator();
        while (phases.hasNext()) {
            String name = (String)phases.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(listener, name, 1);
            phase.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
            this.updateListener(listener, name, 2);
        }
        this.clean(releaseDescriptor, listener, reactorProjects);
        this.updateListener(listener, "updateVersions", 12);
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        if (StringUtils.isNotEmpty((String)relativePathProjectDirectory)) {
            return new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return checkoutDirectory;
    }

    private ReleaseDescriptor loadReleaseDescriptor(ReleaseDescriptor releaseDescriptor, ReleaseManagerListener listener) throws ReleaseExecutionException {
        try {
            this.updateListener(listener, "verify-release-configuration", 1);
            ReleaseDescriptor descriptor = this.configStore.read(releaseDescriptor);
            this.updateListener(listener, "verify-release-configuration", 2);
            return descriptor;
        }
        catch (ReleaseDescriptorStoreException e) {
            this.updateListener(listener, e.getMessage(), 99);
            throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), e);
        }
    }

    public void clean(ReleaseDescriptor releaseDescriptor, ReleaseManagerListener listener, List reactorProjects) {
        this.updateListener(listener, "cleanup", 1);
        this.getLogger().info("Cleaning up after release...");
        this.configStore.delete(releaseDescriptor);
        LinkedHashSet phases = new LinkedHashSet(this.preparePhases);
        phases.addAll(this.branchPhases);
        Iterator i = phases.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            ReleasePhase phase = (ReleasePhase)this.releasePhases.get(name);
            phase.clean(reactorProjects);
        }
        this.updateListener(listener, "cleanup", 2);
    }

    void setConfigStore(ReleaseDescriptorStore configStore) {
        this.configStore = configStore;
    }

    void updateListener(ReleaseManagerListener listener, String name, int state) {
        if (listener != null) {
            switch (state) {
                case 11: {
                    listener.goalStart(name, this.getGoalPhases(name));
                    break;
                }
                case 12: {
                    listener.goalEnd();
                    break;
                }
                case 0: {
                    listener.phaseSkip(name);
                    break;
                }
                case 1: {
                    listener.phaseStart(name);
                    break;
                }
                case 2: {
                    listener.phaseEnd();
                    break;
                }
                default: {
                    listener.error(name);
                }
            }
        }
    }

    private List getGoalPhases(String name) {
        ArrayList phases = new ArrayList();
        if ("prepare".equals(name)) {
            phases.addAll(this.preparePhases);
        } else if ("perform".equals(name)) {
            phases.addAll(this.performPhases);
        } else if ("rollback".equals(name)) {
            phases.addAll(this.rollbackPhases);
        } else if ("branch".equals(name)) {
            phases.addAll(this.branchPhases);
        } else if ("updateVersions".equals(name)) {
            phases.addAll(this.updateVersionsPhases);
        }
        return Collections.unmodifiableList(phases);
    }

    private void logInfo(ReleaseResult result, String message) {
        if (result != null) {
            result.appendInfo(message);
        }
        this.getLogger().info(message);
    }

    private void captureException(ReleaseResult result, ReleaseManagerListener listener, Exception e) {
        this.updateListener(listener, e.getMessage(), 99);
        result.appendError(e);
        result.setResultCode(1);
    }

    public void branch(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, dryRun);
    }

    public void branch(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.branch(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, dryRun, listener);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    public void perform(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean clean) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, clean);
    }

    public ReleaseResult performWithResult(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, ReleaseManagerListener listener) {
        return this.performWithResult(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects);
    }

    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean resume, boolean dryRun) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun);
    }

    public void prepare(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun, listener);
    }

    public ReleaseResult prepareWithResult(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean resume, boolean dryRun, ReleaseManagerListener listener) {
        return this.prepareWithResult(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, resume, dryRun, listener);
    }

    public void rollback(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, ReleaseManagerListener listener) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, listener);
    }

    public void rollback(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        this.rollback(releaseDescriptor, new DefaultReleaseEnvironment().setSettings(settings), reactorProjects, null);
    }
}

