/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleRelocator
implements Relocator {
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set includes;
    private final Set excludes;

    public SimpleRelocator(String patt, String shadedPattern, List includes, List excludes) {
        this.pattern = patt.replace('/', '.');
        this.pathPattern = patt.replace('.', '/');
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern.replace('/', '.');
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        this.includes = SimpleRelocator.normalizePatterns(includes);
        this.excludes = SimpleRelocator.normalizePatterns(excludes);
    }

    private static Set normalizePatterns(Collection patterns) {
        LinkedHashSet<String> normalized = null;
        if (patterns != null && !patterns.isEmpty()) {
            normalized = new LinkedHashSet<String>();
            Iterator i = patterns.iterator();
            while (i.hasNext()) {
                String pattern = (String)i.next();
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*")) continue;
                String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
                normalized.add(packagePattern);
            }
        }
        return normalized;
    }

    private boolean isIncluded(String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            Iterator i = this.includes.iterator();
            while (i.hasNext()) {
                String include = (String)i.next();
                if (!SelectorUtils.matchPath((String)include, (String)path, (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                String exclude = (String)i.next();
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!this.isIncluded(path) || this.isExcluded(path)) {
            return false;
        }
        return path.startsWith(this.pathPattern);
    }

    public boolean canRelocateClass(String clazz) {
        return clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    public String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }
}

