/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.plugins.help.HelpMojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.util.PluginUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="describe", requiresProject=false, aggregator=true)
public class DescribeMojo
extends AbstractHelpMojo {
    private static final int INDENT_SIZE = 2;
    private static final String UNKNOWN = "Unknown";
    private static final String NOT_DEFINED = "Not defined";
    private static final String NO_REASON = "No reason given";
    private static final Pattern EXPRESSION = Pattern.compile("^\\$\\{([^}]+)\\}$");
    @Component
    private MavenPluginManagerHelper pluginManager;
    @Component
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Component
    private PluginVersionResolver pluginVersionResolver;
    @Component
    private DefaultLifecycles defaultLifecycles;
    @Component
    private Map<String, LifecycleMapping> lifecycleMappings;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @org.apache.maven.plugins.annotations.Parameter(property="plugin", alias="prefix")
    private String plugin;
    @org.apache.maven.plugins.annotations.Parameter(property="groupId")
    private String groupId;
    @org.apache.maven.plugins.annotations.Parameter(property="artifactId")
    private String artifactId;
    @org.apache.maven.plugins.annotations.Parameter(property="version")
    private String version;
    @org.apache.maven.plugins.annotations.Parameter(property="goal")
    private String goal;
    @org.apache.maven.plugins.annotations.Parameter(property="detail", defaultValue="false")
    private boolean detail;
    @org.apache.maven.plugins.annotations.Parameter(property="minimal", defaultValue="false")
    private boolean minimal;
    @org.apache.maven.plugins.annotations.Parameter(property="cmd")
    private String cmd;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringBuilder descriptionBuffer = new StringBuilder();
        boolean describePlugin = true;
        if (StringUtils.isNotEmpty((String)this.cmd)) {
            describePlugin = this.describeCommand(descriptionBuffer);
        }
        if (describePlugin) {
            PluginInfo pi = this.parsePluginLookupInfo();
            PluginDescriptor descriptor = this.lookupPluginDescriptor(pi);
            if (StringUtils.isNotEmpty((String)this.goal)) {
                MojoDescriptor mojo = descriptor.getMojo(this.goal);
                if (mojo == null) {
                    throw new MojoFailureException("The goal '" + this.goal + "' does not exist in the plugin '" + pi.getPrefix() + "'");
                }
                this.describeMojo(mojo, descriptionBuffer);
            } else {
                this.describePlugin(descriptor, descriptionBuffer);
            }
        }
        this.writeDescription(descriptionBuffer);
    }

    private void writeDescription(StringBuilder descriptionBuffer) throws MojoExecutionException {
        if (this.output != null) {
            try {
                DescribeMojo.writeFile(this.output, descriptionBuffer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write plugin/goal description to output: " + this.output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Wrote descriptions to: " + this.output));
        } else {
            this.getLog().info((CharSequence)descriptionBuffer.toString());
        }
    }

    private PluginDescriptor lookupPluginDescriptor(PluginInfo pi) throws MojoExecutionException, MojoFailureException {
        Plugin forLookup = null;
        if (StringUtils.isNotEmpty((String)pi.getPrefix())) {
            try {
                forLookup = this.mojoDescriptorCreator.findPluginForPrefix(pi.getPrefix(), this.session);
            }
            catch (NoPluginFoundForPrefixException e) {
                throw new MojoExecutionException("Unable to find the plugin with prefix: " + pi.getPrefix(), (Exception)((Object)e));
            }
        } else if (StringUtils.isNotEmpty((String)pi.getGroupId()) && StringUtils.isNotEmpty((String)pi.getArtifactId())) {
            forLookup = new Plugin();
            forLookup.setGroupId(pi.getGroupId());
            forLookup.setArtifactId(pi.getArtifactId());
        }
        if (forLookup == null) {
            String msg = "You must specify either: both 'groupId' and 'artifactId' parameters OR a 'plugin' parameter OR a 'cmd' parameter. For instance:" + LS + "  # mvn help:describe -Dcmd=install" + LS + "or" + LS + "  # mvn help:describe -Dcmd=help:describe" + LS + "or" + LS + "  # mvn help:describe -Dplugin=org.apache.maven.plugins:maven-help-plugin" + LS + "or" + LS + "  # mvn help:describe -DgroupId=org.apache.maven.plugins -DartifactId=maven-help-plugin" + LS + LS + "Try 'mvn help:help -Ddetail=true' for more information.";
            throw new MojoFailureException(msg);
        }
        if (StringUtils.isNotEmpty((String)pi.getVersion())) {
            forLookup.setVersion(pi.getVersion());
        } else {
            try {
                DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(forLookup, this.session);
                versionRequest.setPom(this.project.getModel());
                PluginVersionResult versionResult = this.pluginVersionResolver.resolve((PluginVersionRequest)versionRequest);
                forLookup.setVersion(versionResult.getVersion());
            }
            catch (PluginVersionResolutionException e) {
                throw new MojoExecutionException("Unable to resolve the version of the plugin with prefix: " + pi.getPrefix(), (Exception)((Object)e));
            }
        }
        try {
            return this.pluginManager.getPluginDescriptor(forLookup, this.session);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error retrieving plugin descriptor for:" + LS + LS + "groupId: '" + this.groupId + "'" + LS + "artifactId: '" + this.artifactId + "'" + LS + "version: '" + this.version + "'" + LS + LS, e);
        }
    }

    private PluginInfo parsePluginLookupInfo() throws MojoFailureException {
        PluginInfo pi = new PluginInfo();
        if (StringUtils.isNotEmpty((String)this.plugin)) {
            if (this.plugin.indexOf(58) > -1) {
                String[] pluginParts = this.plugin.split(":");
                switch (pluginParts.length) {
                    case 1: {
                        pi.setPrefix(pluginParts[0]);
                        break;
                    }
                    case 2: {
                        pi.setGroupId(pluginParts[0]);
                        pi.setArtifactId(pluginParts[1]);
                        break;
                    }
                    case 3: {
                        pi.setGroupId(pluginParts[0]);
                        pi.setArtifactId(pluginParts[1]);
                        pi.setVersion(pluginParts[2]);
                        break;
                    }
                    default: {
                        throw new MojoFailureException("plugin parameter must be a plugin prefix, or conform to: 'groupId:artifactId[:version]'.");
                    }
                }
            } else {
                pi.setPrefix(this.plugin);
            }
        } else {
            pi.setGroupId(this.groupId);
            pi.setArtifactId(this.artifactId);
            pi.setVersion(this.version);
        }
        return pi;
    }

    private void describePlugin(PluginDescriptor pd, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        DescribeMojo.append(buffer, pd.getId(), 0);
        buffer.append(LS);
        String name = pd.getName();
        if (name == null) {
            ArtifactCoordinate coordinate = this.toArtifactCoordinate(pd, "jar");
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            pbr.setRemoteRepositories(this.remoteRepositories);
            pbr.setProject(null);
            pbr.setValidationLevel(0);
            try {
                Artifact artifact = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)pbr, coordinate).getArtifact();
                name = this.projectBuilder.build(artifact, (ProjectBuildingRequest)pbr).getProject().getName();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to get the name of the plugin " + pd.getId() + ": " + e.getMessage()));
                name = pd.getId();
            }
        }
        DescribeMojo.append(buffer, "Name", MessageUtils.buffer().strong((Object)name).toString(), 0);
        DescribeMojo.appendAsParagraph(buffer, "Description", DescribeMojo.toDescription(pd.getDescription()), 0);
        DescribeMojo.append(buffer, "Group Id", pd.getGroupId(), 0);
        DescribeMojo.append(buffer, "Artifact Id", pd.getArtifactId(), 0);
        DescribeMojo.append(buffer, "Version", pd.getVersion(), 0);
        DescribeMojo.append(buffer, "Goal Prefix", MessageUtils.buffer().strong((Object)pd.getGoalPrefix()).toString(), 0);
        buffer.append(LS);
        ArrayList mojos = pd.getMojos();
        if (mojos == null) {
            DescribeMojo.append(buffer, "This plugin has no goals.", 0);
            return;
        }
        if (!this.minimal) {
            DescribeMojo.append(buffer, "This plugin has " + mojos.size() + " goal" + (mojos.size() > 1 ? "s" : "") + ":", 0);
            buffer.append(LS);
            mojos = new ArrayList(mojos);
            PluginUtils.sortMojos(mojos);
            for (MojoDescriptor md : mojos) {
                this.describeMojoGuts(md, buffer, this.detail);
                buffer.append(LS);
            }
        }
        if (!this.detail) {
            buffer.append("For more information, run 'mvn help:describe [...] -Ddetail'");
            buffer.append(LS);
        }
    }

    private void describeMojo(MojoDescriptor md, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        buffer.append("Mojo: '").append(md.getFullGoalName()).append("'");
        buffer.append(LS);
        this.describeMojoGuts(md, buffer, this.detail);
        buffer.append(LS);
        if (!this.detail) {
            buffer.append("For more information, run 'mvn help:describe [...] -Ddetail'");
            buffer.append(LS);
        }
    }

    private void describeMojoGuts(MojoDescriptor md, StringBuilder buffer, boolean fullDescription) throws MojoFailureException, MojoExecutionException {
        DescribeMojo.append(buffer, MessageUtils.buffer().strong((Object)md.getFullGoalName()).toString(), 0);
        DescribeMojo.appendAsParagraph(buffer, "Description", DescribeMojo.toDescription(md.getDescription()), 1);
        String deprecation = md.getDeprecated();
        if (deprecation != null && deprecation.length() <= 0) {
            deprecation = NO_REASON;
        }
        if (StringUtils.isNotEmpty((String)deprecation)) {
            DescribeMojo.append(buffer, MessageUtils.buffer().warning((Object)("Deprecated. " + deprecation)).toString(), 1);
        }
        if (this.isReportGoal(md)) {
            DescribeMojo.append(buffer, "Note", "This goal should be used as a Maven report.", 1);
        }
        if (!fullDescription) {
            return;
        }
        DescribeMojo.append(buffer, "Implementation", md.getImplementation(), 1);
        DescribeMojo.append(buffer, "Language", md.getLanguage(), 1);
        String phase = md.getPhase();
        if (StringUtils.isNotEmpty((String)phase)) {
            DescribeMojo.append(buffer, "Bound to phase", phase, 1);
        }
        String eGoal = md.getExecuteGoal();
        String eLife = md.getExecuteLifecycle();
        String ePhase = md.getExecutePhase();
        if (StringUtils.isNotEmpty((String)eGoal) || StringUtils.isNotEmpty((String)ePhase)) {
            DescribeMojo.append(buffer, "Before this goal executes, it will call:", 1);
            if (StringUtils.isNotEmpty((String)eGoal)) {
                DescribeMojo.append(buffer, "Single goal", "'" + eGoal + "'", 2);
            }
            if (StringUtils.isNotEmpty((String)ePhase)) {
                String s = "Phase: '" + ePhase + "'";
                if (StringUtils.isNotEmpty((String)eLife)) {
                    s = s + " in Lifecycle Overlay: '" + eLife + "'";
                }
                DescribeMojo.append(buffer, s, 2);
            }
        }
        buffer.append(LS);
        this.describeMojoParameters(md, buffer);
    }

    private void describeMojoParameters(MojoDescriptor md, StringBuilder buffer) throws MojoFailureException, MojoExecutionException {
        ArrayList params = md.getParameters();
        if (params == null || params.isEmpty()) {
            DescribeMojo.append(buffer, "This mojo doesn't use any parameters.", 1);
            return;
        }
        params = new ArrayList(params);
        PluginUtils.sortMojoParameters(params);
        DescribeMojo.append(buffer, "Available parameters:", 1);
        for (Parameter parameter : params) {
            String expression;
            if (!parameter.isEditable()) continue;
            buffer.append(LS);
            String defaultVal = parameter.getDefaultValue();
            if (defaultVal == null) {
                defaultVal = md.getMojoConfiguration().getChild(parameter.getName()).getAttribute("default-value", null);
            }
            defaultVal = StringUtils.isNotEmpty((String)defaultVal) ? " (Default: " + MessageUtils.buffer().strong((Object)defaultVal) + ")" : "";
            DescribeMojo.append(buffer, MessageUtils.buffer().strong((Object)parameter.getName()) + defaultVal, 2);
            String alias = parameter.getAlias();
            if (!StringUtils.isEmpty((String)alias)) {
                DescribeMojo.append(buffer, "Alias", alias, 3);
            }
            if (parameter.isRequired()) {
                DescribeMojo.append(buffer, "Required", "true", 3);
            }
            if (StringUtils.isEmpty((String)(expression = parameter.getExpression()))) {
                expression = md.getMojoConfiguration().getChild(parameter.getName()).getValue(null);
            }
            if (StringUtils.isNotEmpty((String)expression)) {
                Matcher matcher = EXPRESSION.matcher(expression);
                if (matcher.matches()) {
                    DescribeMojo.append(buffer, "User property", matcher.group(1), 3);
                } else {
                    DescribeMojo.append(buffer, "Expression", expression, 3);
                }
            }
            DescribeMojo.append(buffer, DescribeMojo.toDescription(parameter.getDescription()), 3);
            String deprecation = parameter.getDeprecated();
            if (deprecation != null && deprecation.length() <= 0) {
                deprecation = NO_REASON;
            }
            if (!StringUtils.isNotEmpty((String)deprecation)) continue;
            DescribeMojo.append(buffer, MessageUtils.buffer().warning((Object)("Deprecated. " + deprecation)).toString(), 3);
        }
    }

    private boolean describeCommand(StringBuilder descriptionBuffer) throws MojoFailureException, MojoExecutionException {
        MojoDescriptor mojoDescriptor;
        if (this.cmd.indexOf(58) == -1) {
            Lifecycle lifecycle = (Lifecycle)this.defaultLifecycles.getPhaseToLifecycleMap().get(this.cmd);
            if (lifecycle == null) {
                throw new MojoExecutionException("The given phase '" + this.cmd + "' is an unknown phase.");
            }
            Map defaultLifecyclePhases = ((org.apache.maven.lifecycle.mapping.Lifecycle)this.lifecycleMappings.get(this.project.getPackaging()).getLifecycles().get("default")).getPhases();
            List phases = lifecycle.getPhases();
            if (lifecycle.getDefaultPhases() == null) {
                descriptionBuffer.append("'").append(this.cmd);
                descriptionBuffer.append("' is a phase corresponding to this plugin:").append(LS);
                for (String key : phases) {
                    if (!key.equals(this.cmd) || defaultLifecyclePhases.get(key) == null) continue;
                    descriptionBuffer.append((String)defaultLifecyclePhases.get(key));
                    descriptionBuffer.append(LS);
                }
                descriptionBuffer.append(LS);
                descriptionBuffer.append("It is a part of the lifecycle for the POM packaging '");
                descriptionBuffer.append(this.project.getPackaging());
                descriptionBuffer.append("'. This lifecycle includes the following phases:");
                descriptionBuffer.append(LS);
                for (String key : phases) {
                    descriptionBuffer.append("* ").append(key).append(": ");
                    String value = (String)defaultLifecyclePhases.get(key);
                    if (StringUtils.isNotEmpty((String)value)) {
                        StringTokenizer tok = new StringTokenizer(value, ",");
                        while (tok.hasMoreTokens()) {
                            descriptionBuffer.append(tok.nextToken().trim());
                            if (!tok.hasMoreTokens()) {
                                descriptionBuffer.append(LS);
                                continue;
                            }
                            descriptionBuffer.append(", ");
                        }
                        continue;
                    }
                    descriptionBuffer.append(NOT_DEFINED).append(LS);
                }
            } else {
                descriptionBuffer.append("'").append(this.cmd);
                descriptionBuffer.append("' is a phase within the '").append(lifecycle.getId());
                descriptionBuffer.append("' lifecycle, which has the following phases: ");
                descriptionBuffer.append(LS);
                for (String key : phases) {
                    descriptionBuffer.append("* ").append(key).append(": ");
                    if (lifecycle.getDefaultPhases().get(key) != null) {
                        descriptionBuffer.append((String)lifecycle.getDefaultPhases().get(key)).append(LS);
                        continue;
                    }
                    descriptionBuffer.append(NOT_DEFINED).append(LS);
                }
            }
            return false;
        }
        try {
            mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(this.cmd, this.session, this.project);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to get descriptor for " + this.cmd, e);
        }
        descriptionBuffer.append("'").append(this.cmd).append("' is a plugin goal (aka mojo)").append(".");
        descriptionBuffer.append(LS);
        this.plugin = mojoDescriptor.getPluginDescriptor().getId();
        this.goal = mojoDescriptor.getGoal();
        return true;
    }

    private static List<String> toLines(String text, int indent, int indentSize, int lineLength) throws MojoFailureException, MojoExecutionException {
        try {
            Method m = HelpMojo.class.getDeclaredMethod("toLines", String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            List output = (List)m.invoke(HelpMojo.class, text, indent, indentSize, lineLength);
            if (output == null) {
                throw new MojoExecutionException("No output was specified.");
            }
            return output;
        }
        catch (SecurityException e) {
            throw new MojoFailureException("SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("IllegalArgumentException: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new MojoFailureException("NoSuchMethodException: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MojoFailureException("IllegalAccessException: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NegativeArraySizeException) {
                throw new MojoFailureException("NegativeArraySizeException: " + cause.getMessage());
            }
            throw new MojoFailureException("InvocationTargetException: " + e.getMessage());
        }
    }

    private static void append(StringBuilder sb, String description, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)description)) {
            sb.append(UNKNOWN).append(LS);
            return;
        }
        for (String line : DescribeMojo.toLines(description, indent, 2, 79)) {
            sb.append(line).append(LS);
        }
    }

    private static void append(StringBuilder sb, String key, String value, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("Key is required!");
        }
        if (StringUtils.isEmpty((String)value)) {
            value = UNKNOWN;
        }
        String description = key + ": " + value;
        for (String line : DescribeMojo.toLines(description, indent, 2, 79)) {
            sb.append(line).append(LS);
        }
    }

    private static void appendAsParagraph(StringBuilder sb, String key, String value, int indent) throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isEmpty((String)value)) {
            value = UNKNOWN;
        }
        String description = key == null ? value : key + ": " + value;
        List<String> l1 = DescribeMojo.toLines(description, indent, 2, 77);
        List<String> l2 = DescribeMojo.toLines(description, indent + 1, 2, 79);
        l2.set(0, l1.get(0));
        for (String line : l2) {
            sb.append(line).append(LS);
        }
    }

    private boolean isReportGoal(MojoDescriptor md) {
        PluginDescriptor pd = md.getPluginDescriptor();
        ArrayList<URL> urls = new ArrayList<URL>();
        DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        pbr.setRemoteRepositories(this.remoteRepositories);
        pbr.setResolveDependencies(true);
        pbr.setProject(null);
        pbr.setValidationLevel(0);
        try {
            Artifact jar = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)pbr, this.toArtifactCoordinate(pd, "jar")).getArtifact();
            Artifact pom = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)pbr, this.toArtifactCoordinate(pd, "pom")).getArtifact();
            MavenProject project = this.projectBuilder.build(pom.getFile(), (ProjectBuildingRequest)pbr).getProject();
            urls.add(jar.getFile().toURI().toURL());
            for (Object artifact : project.getCompileClasspathElements()) {
                urls.add(new File((String)artifact).toURI().toURL());
            }
            URLClassLoader classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            return MavenReport.class.isAssignableFrom(Class.forName(md.getImplementation(), false, classLoader));
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Couldn't identify if this goal is a report goal: " + e.getMessage()));
            return false;
        }
    }

    private ArtifactCoordinate toArtifactCoordinate(PluginDescriptor pd, String type) {
        return this.getArtifactCoordinate(pd.getGroupId(), pd.getArtifactId(), pd.getVersion(), type);
    }

    private static String toDescription(String description) {
        if (StringUtils.isNotEmpty((String)description)) {
            return GeneratorUtils.toText((String)description);
        }
        return "(no description available)";
    }

    static class PluginInfo {
        private String prefix;
        private String groupId;
        private String artifactId;
        private String version;

        PluginInfo() {
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}

