/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.IOException;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.CommandLineUtils;
import org.apache.maven.plugin.assembly.utils.PrefixedObjectBasedValueSource;
import org.apache.maven.plugin.assembly.utils.PrefixedPropertiesInterpolationValueSource;
import org.apache.maven.plugin.assembly.utils.PropertiesInterpolationValueSource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;

public final class AssemblyFormatUtils {
    private AssemblyFormatUtils() {
    }

    public static String getDistributionName(Assembly assembly, AssemblerConfigurationSource configSource) {
        String finalName = configSource.getFinalName();
        boolean appendAssemblyId = configSource.isAssemblyIdAppended();
        String classifier = configSource.getClassifier();
        String distributionName = finalName;
        if (appendAssemblyId) {
            if (!StringUtils.isEmpty((String)assembly.getId())) {
                distributionName = finalName + "-" + assembly.getId();
            }
        } else if (classifier != null) {
            distributionName = finalName + "-" + classifier;
        }
        return distributionName;
    }

    public static String getOutputDirectory(String output, MavenProject mainProject, MavenProject artifactProject, String finalName) throws AssemblyFormattingException {
        return AssemblyFormatUtils.getOutputDirectory(output, mainProject, artifactProject, finalName, "artifact.");
    }

    public static String getOutputDirectory(String output, MavenProject mainProject, MavenProject artifactProject, String finalName, String artifactProjectRefName) throws AssemblyFormattingException {
        String value;
        if (artifactProjectRefName == null) {
            artifactProjectRefName = "artifact.";
        }
        if (!artifactProjectRefName.endsWith(".")) {
            artifactProjectRefName = artifactProjectRefName + ".";
        }
        if ((value = output) == null) {
            value = "";
        }
        if (artifactProjectRefName != null && !artifactProjectRefName.endsWith(".")) {
            artifactProjectRefName = artifactProjectRefName + ".";
        }
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        Properties specialExpressionOverrides = new Properties();
        if (finalName != null) {
            specialExpressionOverrides.setProperty("finalName", finalName);
            specialExpressionOverrides.setProperty("build.finalName", finalName);
        }
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(specialExpressionOverrides));
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("pom.", mainProject));
        }
        if (artifactProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource(artifactProjectRefName, artifactProject));
            if (!"artifact.".equals(artifactProjectRefName)) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("artifact.", artifactProject));
            }
        }
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)mainProject));
            interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(mainProject.getProperties()));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesInterpolationValueSource("pom.properties.", mainProject.getProperties()));
        }
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(System.getProperties()));
        try {
            interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(CommandLineUtils.getSystemEnvVars(false)));
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Failed to retrieve OS environment variables. Reason: " + e.getMessage(), e);
        }
        value = interpolator.interpolate(value, "__project");
        if (value.length() > 0 && !value.endsWith("/") && !value.endsWith("\\")) {
            value = value + "/";
        }
        if (value.length() > 0 && (value.startsWith("/") || value.startsWith("\\"))) {
            value = value.substring(1);
        }
        return value;
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact, MavenProject mainProject, MavenProject artifactProject) throws AssemblyFormattingException {
        return AssemblyFormatUtils.evaluateFileNameMapping(expression, artifact, mainProject, artifactProject, "artifact.");
    }

    public static String evaluateFileNameMapping(String expression, Artifact artifact, MavenProject mainProject, MavenProject artifactProject, String artifactProjectRefName) throws AssemblyFormattingException {
        String value = expression;
        if (artifactProjectRefName == null) {
            artifactProjectRefName = "artifact.";
        }
        if (!artifactProjectRefName.endsWith(".")) {
            artifactProjectRefName = artifactProjectRefName + ".";
        }
        artifact.isSnapshot();
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource(artifactProjectRefName, artifact));
        interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource(artifactProjectRefName, artifact.getArtifactHandler()));
        interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource(artifactProjectRefName + (artifactProjectRefName.endsWith(".") ? "" : ".") + "handler.", artifact.getArtifactHandler()));
        if (artifactProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource(artifactProjectRefName, artifactProject));
        }
        if (!"artifact.".equals(artifactProjectRefName)) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("artifact.", artifact));
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("artifact.", artifact.getArtifactHandler()));
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("artifact.handler.", artifact.getArtifactHandler()));
            if (artifactProject != null) {
                interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("artifact.", artifactProject));
            }
        }
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PrefixedObjectBasedValueSource("pom.", mainProject));
            interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)mainProject));
        }
        Properties specialRules = new Properties();
        String classifier = artifact.getClassifier();
        if (classifier != null) {
            specialRules.setProperty("dashClassifier?", "-" + classifier);
        } else {
            specialRules.setProperty("dashClassifier?", "");
        }
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(specialRules));
        if (mainProject != null) {
            interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(mainProject.getProperties()));
            interpolator.addValueSource((ValueSource)new PrefixedPropertiesInterpolationValueSource("pom.properties.", mainProject.getProperties()));
        }
        interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(System.getProperties()));
        try {
            interpolator.addValueSource((ValueSource)new PropertiesInterpolationValueSource(CommandLineUtils.getSystemEnvVars(false)));
        }
        catch (IOException e) {
            throw new AssemblyFormattingException("Failed to retrieve OS environment variables. Reason: " + e.getMessage(), e);
        }
        value = interpolator.interpolate(value, "__artifact");
        return value;
    }
}

