/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugin.assembly.archive.ManifestCreationFinalizer;
import org.apache.maven.plugin.assembly.archive.archiver.AssemblyProxyArchiver;
import org.apache.maven.plugin.assembly.archive.phase.AssemblyArchiverPhase;
import org.apache.maven.plugin.assembly.filter.ComponentsXmlArchiverFileFilter;
import org.apache.maven.plugin.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.model.ContainerDescriptorHandlerConfig;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.AssemblyFormatUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.filters.JarSecurityFileSelector;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.collections.ActiveCollectionManager;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultAssemblyArchiver
extends AbstractLogEnabled
implements AssemblyArchiver {
    private ArchiverManager archiverManager;
    private List assemblyPhases;
    private Map containerDescriptorHandlers;

    public DefaultAssemblyArchiver() {
    }

    public DefaultAssemblyArchiver(ArchiverManager archiverManager, ActiveCollectionManager collectionManager, List assemblyPhases) {
        this.archiverManager = archiverManager;
        this.assemblyPhases = assemblyPhases;
    }

    public File createArchive(Assembly assembly, String fullName, String format, AssemblerConfigurationSource configSource) throws ArchiveCreationException, AssemblyFormattingException, InvalidAssemblerConfigurationException {
        String filename = fullName;
        if (!configSource.isIgnoreDirFormatExtensions() || !format.startsWith("dir")) {
            filename = filename + "." + format;
        }
        AssemblyFileUtils.verifyTempDirectoryAvailability(configSource.getTemporaryRootDirectory(), this.getLogger());
        File outputDirectory = configSource.getOutputDirectory();
        File destFile = new File(outputDirectory, filename);
        try {
            String finalName = configSource.getFinalName();
            String specifiedBasedir = assembly.getBaseDirectory();
            String basedir = finalName;
            if (specifiedBasedir != null) {
                basedir = AssemblyFormatUtils.getOutputDirectory(specifiedBasedir, configSource.getProject(), null, finalName);
            }
            List containerHandlers = this.selectContainerDescriptorHandlers(assembly.getContainerDescriptorHandlers());
            Archiver archiver = this.createArchiver(format, assembly.isIncludeBaseDirectory(), basedir, configSource, containerHandlers);
            archiver.setDestFile(destFile);
            Iterator phaseIterator = this.assemblyPhases.iterator();
            while (phaseIterator.hasNext()) {
                AssemblyArchiverPhase phase = (AssemblyArchiverPhase)phaseIterator.next();
                phase.execute(assembly, archiver, configSource);
            }
            archiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ArchiveCreationException("Error creating assembly archive " + assembly.getId() + ": " + e.getMessage(), e);
        }
        catch (NoSuchArchiverException e) {
            throw new ArchiveCreationException("Unable to obtain archiver for extension '" + format + "'");
        }
        return destFile;
    }

    private List selectContainerDescriptorHandlers(List requestedContainerDescriptorHandlers) throws InvalidAssemblerConfigurationException {
        this.getLogger().debug("All known ContainerDescritporHandler components: " + (this.containerDescriptorHandlers == null ? "none; map is null." : "" + this.containerDescriptorHandlers.keySet()));
        if (requestedContainerDescriptorHandlers == null) {
            requestedContainerDescriptorHandlers = new ArrayList();
        }
        ArrayList<ContainerDescriptorHandler> handlers = new ArrayList<ContainerDescriptorHandler>();
        boolean foundPlexus = false;
        if (requestedContainerDescriptorHandlers != null && !requestedContainerDescriptorHandlers.isEmpty()) {
            Iterator it = requestedContainerDescriptorHandlers.iterator();
            while (it.hasNext()) {
                ContainerDescriptorHandlerConfig config = (ContainerDescriptorHandlerConfig)it.next();
                String hint = config.getHandlerName();
                ContainerDescriptorHandler handler = (ContainerDescriptorHandler)this.containerDescriptorHandlers.get(hint);
                if (handler == null) {
                    throw new InvalidAssemblerConfigurationException("Cannot find ContainerDescriptorHandler with hint: " + hint);
                }
                System.out.println("Found container descriptor handler with hint: " + hint + " (component: " + handler + ")");
                handlers.add(handler);
                if (!"plexus".equals(hint)) continue;
                foundPlexus = true;
            }
        }
        if (!foundPlexus) {
            handlers.add(new ComponentsXmlArchiverFileFilter());
        }
        return handlers;
    }

    protected Archiver createArchiver(String format, boolean includeBaseDir, String finalName, AssemblerConfigurationSource configSource, List containerHandlers) throws ArchiverException, NoSuchArchiverException {
        Archiver archiver = format.startsWith("tar") ? this.createTarArchiver(format, configSource.getTarLongFileMode()) : ("war".equals(format) ? this.createWarArchiver() : this.archiverManager.getArchiver(format));
        List<JarSecurityFileSelector> extraSelectors = null;
        if (archiver instanceof JarArchiver) {
            extraSelectors = Collections.singletonList(new JarSecurityFileSelector());
        }
        List<ManifestCreationFinalizer> extraFinalizers = null;
        if ("jar".equals(format)) {
            extraFinalizers = Collections.singletonList(new ManifestCreationFinalizer(configSource.getProject(), configSource.getJarArchiveConfiguration()));
        }
        String prefix = "";
        if (includeBaseDir) {
            prefix = finalName;
        }
        archiver = new AssemblyProxyArchiver(prefix, archiver, containerHandlers, extraSelectors, extraFinalizers, this.getLogger(), configSource.isDryRun());
        return archiver;
    }

    protected Archiver createWarArchiver() throws NoSuchArchiverException {
        WarArchiver warArchiver = (WarArchiver)this.archiverManager.getArchiver("war");
        warArchiver.setIgnoreWebxml(false);
        return warArchiver;
    }

    protected Archiver createTarArchiver(String format, String tarLongFileMode) throws NoSuchArchiverException, ArchiverException {
        TarArchiver tarArchiver = (TarArchiver)this.archiverManager.getArchiver("tar");
        int index = format.indexOf(46);
        if (index >= 0) {
            TarArchiver.TarCompressionMethod tarCompressionMethod = new TarArchiver.TarCompressionMethod();
            String compression = format.substring(index + 1);
            if ("gz".equals(compression)) {
                tarCompressionMethod.setValue("gzip");
            } else if ("bz2".equals(compression)) {
                tarCompressionMethod.setValue("bzip2");
            } else {
                throw new IllegalArgumentException("Unknown compression format: " + compression);
            }
            tarArchiver.setCompression(tarCompressionMethod);
        }
        TarLongFileMode tarFileMode = new TarLongFileMode();
        tarFileMode.setValue(tarLongFileMode);
        tarArchiver.setLongfile(tarFileMode);
        return tarArchiver;
    }
}

