/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.ldcache.webservices;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.model.ClientResponse;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.ldcache.api.endpoint.LinkedDataEndpointService;
import org.apache.marmotta.platform.ldcache.services.ldcache.LDCacheSailProvider;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.rdfxml.util.RDFXMLPrettyWriter;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/cache")
public class LinkedDataCachingWebService {
    @Inject
    private Logger log;
    @Inject
    private LinkedDataEndpointService endpointService;
    @Inject
    private SesameService sesameService;
    @Inject
    private LDCacheSailProvider cacheSailProvider;

    @GET
    @Path(value="/live")
    public Response retrieveLive(@QueryParam(value="uri") String uri) {
        try {
            ClientResponse response = this.cacheSailProvider.getLDClient().retrieveResource(uri);
            RepositoryConnection con = response.getTriples().getConnection();
            con.begin();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            RDFXMLPrettyWriter handler = new RDFXMLPrettyWriter((OutputStream)out);
            con.export((RDFHandler)handler, new Resource[0]);
            con.commit();
            con.close();
            return Response.ok().entity((Object)new String(out.toByteArray(), "utf-8")).build();
        }
        catch (Exception e) {
            this.log.error("exception while retrieving resource", (Throwable)e);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/cached")
    public Response retrieveCached(@QueryParam(value="uri") String uri) {
        URI resource = this.sesameService.getValueFactory().createURI(uri);
        try {
            this.cacheSailProvider.getLDCache().refreshResource(resource, false);
            return Response.ok().build();
        }
        catch (Exception e) {
            this.log.error("exception while retrieving resource", (Throwable)e);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/refresh")
    public Response refreshCached(@QueryParam(value="uri") String uri) {
        URI resource = this.sesameService.getValueFactory().createURI(uri);
        try {
            this.cacheSailProvider.getLDCache().refreshResource(resource, true);
            return Response.ok().build();
        }
        catch (Exception e) {
            this.log.error("exception while retrieving resource", (Throwable)e);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/expire")
    public Response expireCache(@QueryParam(value="uri") String uri) {
        if (uri != null) {
            URI resource = this.sesameService.getValueFactory().createURI(uri);
            this.cacheSailProvider.getLDCache().expire(resource);
        } else {
            this.cacheSailProvider.getLDCache().expireAll();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/endpoint")
    public Response registerEndpoint(@QueryParam(value="name") String name, @QueryParam(value="prefix") String prefix, @QueryParam(value="endpoint") String endpointUrl, @QueryParam(value="kind") String type, @QueryParam(value="mimetype") String mimetype, @QueryParam(value="expiry") long expiry) {
        if (type == null || !this.getProviderNames().contains(type.toLowerCase())) {
            type = "Linked Data";
        }
        if (prefix != null) {
            try {
                if (prefix.startsWith("~")) {
                    Pattern.compile(prefix.substring("~".length()));
                } else {
                    Pattern.compile(prefix);
                }
            }
            catch (PatternSyntaxException pse) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Regex in prefix detected").build();
            }
        }
        endpointUrl = endpointUrl != null ? endpointUrl.replace('<', '{').replace('>', '}') : "";
        if (mimetype == null) {
            mimetype = "";
        }
        Endpoint endpoint = new Endpoint(name, type, prefix, endpointUrl, mimetype, Long.valueOf(expiry));
        this.endpointService.addEndpoint(endpoint);
        this.cacheSailProvider.updateEndpoints();
        return Response.ok().build();
    }

    @GET
    @Path(value="/endpoint/list")
    @Produces(value={"application/json"})
    public Response listEndpoints() {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        for (Endpoint endpoint : this.endpointService.listEndpoints()) {
            result.add(this.buildEndpointJSON(endpoint));
        }
        return Response.ok().entity(result).build();
    }

    @GET
    @Path(value="/provider/list")
    @Produces(value={"application/json"})
    public Set<String> listProviders() {
        return this.getProviderNames();
    }

    @GET
    @Path(value="/endpoint/{id}")
    @Produces(value={"application/json"})
    public Response retrieveEndpoint(@PathParam(value="id") String id) {
        Endpoint endpoint = this.endpointService.getEndpoint(id);
        if (endpoint == null) {
            return this.notFound(id);
        }
        return Response.ok().entity(this.buildEndpointJSON(endpoint)).build();
    }

    @DELETE
    @Path(value="/endpoint/{id}")
    public Response removeEndpoint(@PathParam(value="id") String id) {
        Endpoint endpoint = this.endpointService.getEndpoint(id);
        if (endpoint == null) {
            return this.notFound(id);
        }
        this.endpointService.removeEndpoint(endpoint);
        this.cacheSailProvider.updateEndpoints();
        return Response.ok().build();
    }

    @POST
    @Path(value="/endpoint/{id}/enable")
    public Response enableEndpoint(@PathParam(value="id") String id, @QueryParam(value="enable") @DefaultValue(value="true") boolean enable) {
        Endpoint endpoint = this.endpointService.getEndpoint(id);
        if (endpoint == null) {
            return this.notFound(id);
        }
        endpoint.setActive(enable);
        this.endpointService.updateEndpoint(endpoint);
        this.cacheSailProvider.updateEndpoints();
        return Response.ok().build();
    }

    private Response notFound(String id) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No endpoint with id " + id + " found!")).build();
    }

    @POST
    @Path(value="/endpoint/{id}/disable")
    public Response disableEndpoint(@PathParam(value="id") String id) {
        return this.enableEndpoint(id, false);
    }

    private Map<String, Object> buildEndpointJSON(Endpoint endpoint) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", endpoint.getName().replaceAll("[^A-Za-z0-9 ]", "").toLowerCase());
        resultMap.put("name", endpoint.getName());
        resultMap.put("endpoint", endpoint.getEndpointUrl());
        resultMap.put("expiry", endpoint.getDefaultExpiry());
        resultMap.put("prefix", endpoint.getUriPattern());
        resultMap.put("kind", endpoint.getType().toString());
        resultMap.put("mimetype", endpoint.getContentTypes());
        resultMap.put("active", endpoint.isActive());
        return resultMap;
    }

    private Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (DataProvider provider : this.cacheSailProvider.getLDClient().getDataProviders()) {
            result.add(provider.getName().toLowerCase());
        }
        return result;
    }
}

