/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static final String md5sum(String string) {
        return HashUtils.calcHash(string, "MD5");
    }

    public static final String md5sum(byte[] bytes) {
        return HashUtils.calcHash(bytes, "MD5");
    }

    public static final String sha1(String string) {
        return HashUtils.calcHash(string, "SHA-1");
    }

    public static final String sha1(byte[] bytes) {
        return HashUtils.calcHash(bytes, "SHA-1");
    }

    private static String calcHash(String string, String algorithm) {
        try {
            return HashUtils.calcHash(string.getBytes("UTF-8"), algorithm);
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    private static String calcHash(byte[] bytes, String algorithm) {
        try {
            MessageDigest m = MessageDigest.getInstance(algorithm);
            m.update(bytes);
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
    }
}

