/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateUtils {
    public static final SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat ISO8601FORMAT_TIME = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    public static final SimpleDateFormat ISO8601FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat FILENAME_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final SimpleDateFormat GMTFORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new DateFormatSymbols(Locale.US));
    private static final DateFormat[] iso8601InputFormats;

    private static DateFormat createDateFormat(String format, String timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, new DateFormatSymbols(Locale.US));
        if (timezone != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return sdf;
    }

    public static synchronized Date parseDate(String date) {
        if (date == null) {
            return null;
        }
        int n = date.length();
        if (n > 2 && date.charAt(n - 3) == ':' && (date.charAt(n - 6) == '+' || date.charAt(n - 6) == '-')) {
            date = date.substring(0, n - 3) + date.substring(n - 2);
        }
        for (DateFormat format : iso8601InputFormats) {
            try {
                return format.parse(date);
            }
            catch (ParseException ignore) {
            }
        }
        return null;
    }

    public static Date getDate(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar getXMLCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(c).normalize();
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    public static Date getDateWithoutFraction(Date date) {
        long seconds = date.getTime() / 1000L;
        return new Date(seconds * 1000L);
    }

    static {
        ISO8601FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601FORMAT_TIME.setTimeZone(TimeZone.getTimeZone("UTC"));
        ISO8601FORMAT_DATE.setTimeZone(TimeZone.getTimeZone("UTC"));
        GMTFORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        iso8601InputFormats = new DateFormat[]{DateUtils.createDateFormat("EEE, dd MMM yyyy HH:mm:ss'Z'", "GMT"), GMTFORMAT, DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", null), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", "UTF"), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", null), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'", "UTF"), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ssZ", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss.SZ", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss", null), DateUtils.createDateFormat("EEE MMM dd HH:mm:ss z yyyy", null), DateUtils.createDateFormat("EEE MMM d HH:mm:ss z yyyy", null), DateUtils.createDateFormat("dd.MM.yyy' 'HH:mm:ss", null), DateUtils.createDateFormat("dd.MM.yyy' 'HH:mm", null)};
    }
}

