/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.model;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class LiteralCommons {
    private static DatatypeFactory dtf;

    public static String createCacheKey(String content, Locale language, URI type) {
        return LiteralCommons.createCacheKey(content, language, type != null ? type.stringValue() : null);
    }

    public static String createCacheKey(String content, Locale language, String type) {
        Hasher hasher = Hashing.goodFastHash((int)64).newHasher();
        hasher.putString((CharSequence)content);
        if (type != null) {
            hasher.putString((CharSequence)type);
        }
        if (language != null) {
            hasher.putString((CharSequence)language.getLanguage().toLowerCase());
        }
        return hasher.hash().toString();
    }

    public static String createCacheKey(Date date, String type) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(date);
        XMLGregorianCalendar xml_cal = dtf.newXMLGregorianCalendar(cal).normalize();
        xml_cal.setTimezone(0);
        return LiteralCommons.createCacheKey(xml_cal.toXMLFormat(), null, type);
    }

    public static String createCacheKey(Literal l) {
        Hasher hasher = Hashing.goodFastHash((int)64).newHasher();
        hasher.putString((CharSequence)l.getLabel());
        if (l.getDatatype() != null) {
            hasher.putString((CharSequence)l.getDatatype().stringValue());
        }
        if (l.getLanguage() != null) {
            hasher.putString((CharSequence)l.getLanguage().toLowerCase());
        }
        return hasher.hash().toString();
    }

    public static String getRDFType(String mime_type) {
        String iw_type = "MultimediaObject";
        if (mime_type.startsWith("image")) {
            iw_type = "Image";
        } else if (mime_type.startsWith("video/flash")) {
            iw_type = "FlashVideo";
        } else if (mime_type.startsWith("video")) {
            iw_type = "Video";
        } else if (mime_type.startsWith("application/pdf")) {
            iw_type = "PDFDocument";
        } else if (mime_type.startsWith("application/msword")) {
            iw_type = "MSWordDocument";
        } else if (mime_type.startsWith("application/vnd.oasis.opendocument") || mime_type.startsWith("application/postscript") || mime_type.startsWith("application/vnd.ms-")) {
            iw_type = "Document";
        } else if (mime_type.startsWith("audio/mpeg") || mime_type.startsWith("audio/mp3")) {
            iw_type = "MP3Audio";
        } else if (mime_type.startsWith("audio")) {
            iw_type = "Audio";
        } else if (mime_type.startsWith("text/html")) {
            iw_type = "HTML";
        } else if (mime_type.startsWith("text")) {
            iw_type = "TEXT";
        }
        return "http://www.kiwi-project.eu/kiwi/core/" + iw_type;
    }

    public static String getXSDType(Class<?> javaClass) {
        if (String.class.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#string";
        }
        if (Integer.class.isAssignableFrom(javaClass) || Integer.TYPE.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        if (Long.class.isAssignableFrom(javaClass) || Long.TYPE.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#long";
        }
        if (Double.class.isAssignableFrom(javaClass) || Double.TYPE.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#double";
        }
        if (Float.class.isAssignableFrom(javaClass) || Float.TYPE.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#float";
        }
        if (Date.class.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#dateTime";
        }
        if (Boolean.class.isAssignableFrom(javaClass) || Boolean.TYPE.isAssignableFrom(javaClass)) {
            return "http://www.w3.org/2001/XMLSchema#boolean";
        }
        return "http://www.w3.org/2001/XMLSchema#string";
    }

    public static String getRDFLangStringType() {
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    }

    static {
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

