/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.http;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public class UriUtil {
    private static final UrlValidator urlValidator = new UrlValidator(9L);

    public static boolean validate(String uri) {
        return StringUtils.isNotBlank((String)uri) && UriUtil.validateJavaNet(uri);
    }

    public static boolean validateApache(String uri) {
        return urlValidator.isValid(uri);
    }

    public static boolean validateJavaNet(String uri) {
        try {
            URI actualUri = URI.create(uri);
            return StringUtils.isNotBlank((String)actualUri.getScheme());
        }
        catch (Exception e1) {
            return false;
        }
    }

    public static String getNamespace(String uri) {
        String last = (uri = uri.trim()).substring(uri.length() - 1);
        if ("#".equals(last) || "/".equals(last)) {
            return null;
        }
        if (uri.contains("#")) {
            return uri.split("#")[0] + "#";
        }
        int index = uri.lastIndexOf(47);
        return uri.substring(0, index + 1);
    }

    public static String getReference(String uri) {
        String last = (uri = uri.trim()).substring(uri.length() - 1);
        if ("#".equals(last) || "/".equals(last)) {
            return null;
        }
        if (uri.contains("#")) {
            return uri.split("#")[1];
        }
        int index = uri.lastIndexOf(47);
        return uri.substring(index + 1);
    }
}

