/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.http;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

public class ETagGenerator {
    public static String getETag(RepositoryConnection conn, String uri) throws RepositoryException {
        URI resource = ResourceUtils.getUriResource(conn, uri);
        return ETagGenerator.getETag(conn, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getETag(RepositoryConnection conn, URI resource) throws RepositoryException {
        if (resource == null) {
            return "";
        }
        Hasher hasher = ETagGenerator.buildHasher();
        hasher.putString((CharSequence)resource.stringValue());
        RepositoryResult outgoing = conn.getStatements((Resource)resource, null, null, true, new Resource[0]);
        try {
            while (outgoing.hasNext()) {
                Statement statement = (Statement)outgoing.next();
                hasher.putString((CharSequence)statement.getPredicate().stringValue());
                hasher.putString((CharSequence)statement.getObject().stringValue());
            }
        }
        finally {
            outgoing.close();
        }
        RepositoryResult incoming = conn.getStatements(null, null, (Value)resource, true, new Resource[0]);
        try {
            while (incoming.hasNext()) {
                Statement statement = (Statement)incoming.next();
                hasher.putString((CharSequence)statement.getSubject().stringValue());
                hasher.putString((CharSequence)statement.getPredicate().stringValue());
            }
        }
        finally {
            incoming.close();
        }
        return hasher.hash().toString();
    }

    public static String getWeakETag(RepositoryConnection conn, String uri) throws RepositoryException {
        URI resource = ResourceUtils.getUriResource(conn, uri);
        return ETagGenerator.getWeakETag(conn, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWeakETag(RepositoryConnection conn, URI resource) throws RepositoryException {
        if (resource == null) {
            return "";
        }
        Hasher hasher = ETagGenerator.buildHasher();
        hasher.putString((CharSequence)resource.stringValue());
        RepositoryResult statements = conn.getStatements((Resource)resource, null, null, true, new Resource[0]);
        try {
            while (statements.hasNext()) {
                Statement statement = (Statement)statements.next();
                hasher.putString((CharSequence)statement.getPredicate().stringValue());
                hasher.putString((CharSequence)statement.getObject().stringValue());
            }
        }
        finally {
            statements.close();
        }
        return hasher.hash().toString();
    }

    private static Hasher buildHasher() {
        HashFunction function = Hashing.goodFastHash((int)16);
        Hasher hasher = function.newHasher();
        return hasher;
    }
}

