/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.http;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ContentType
implements Comparable<ContentType> {
    private String type;
    private String subtype;
    private Charset charset = Charset.defaultCharset();
    private Map<String, String> parameters = new HashMap<String, String>();

    public ContentType(String type, String subtype) {
        this.type = type;
        this.subtype = subtype;
        this.setParameter("q", "1.0");
    }

    public ContentType(String type, String subtype, double q) {
        this.type = type;
        this.subtype = subtype;
        this.setParameter("q", Double.toString(q));
    }

    public ContentType(String type, String subtype, Charset charset) {
        this(type, subtype);
        this.charset = charset;
    }

    public boolean matches(ContentType contentType) {
        if (!contentType.getType().equalsIgnoreCase(this.getType())) {
            return false;
        }
        if (!contentType.getSubtype().equalsIgnoreCase(this.getSubtype())) {
            return false;
        }
        return this.getParameter("rel") == null || this.getParameter("rel").equalsIgnoreCase(contentType.getParameter("rel"));
    }

    public boolean matchesSubtype(ContentType contentType) {
        if (!"*".equals(this.getType()) && !contentType.getType().equalsIgnoreCase(this.getType())) {
            return false;
        }
        String[] componentsMine = this.getSubtype().split("\\+");
        String[] componentsOther = contentType.getSubtype().split("\\+");
        if (componentsOther.length > 1 && !componentsOther[1].equalsIgnoreCase(this.getSubtype())) {
            return false;
        }
        if (!(componentsMine.length != 2 && componentsOther.length != 1 || contentType.getSubtype().equalsIgnoreCase(this.getSubtype()))) {
            return false;
        }
        return this.getParameter("rel") == null || this.getParameter("rel").equalsIgnoreCase(contentType.getParameter("rel"));
    }

    public boolean matchesWildcard(ContentType contentType) {
        if (!"*".equals(this.getType()) && !contentType.getType().equalsIgnoreCase(this.getType())) {
            return false;
        }
        if (!"*".equals(this.getSubtype()) && !contentType.getSubtype().equalsIgnoreCase(this.getSubtype())) {
            return false;
        }
        return this.getParameter("rel") == null || this.getParameter("rel").equalsIgnoreCase(contentType.getParameter("rel"));
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String getMime() {
        return this.type + "/" + this.subtype;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
        this.setParameter("charset", charset.name().toLowerCase());
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public void setParameter(String key, String value) {
        if (value.startsWith("\"")) {
            this.parameters.put(key, value.substring(1, value.length() - 1));
        } else {
            this.parameters.put(key, value);
        }
    }

    public String toString() {
        StringBuilder base = new StringBuilder();
        base.append(this.type);
        base.append("/");
        base.append(this.subtype);
        for (String key : this.parameters.keySet()) {
            base.append("; ");
            base.append(key);
            base.append("=");
            base.append(this.parameters.get(key));
        }
        return base.toString();
    }

    public String toStringNoParameters() {
        return this.toString(new String[0]);
    }

    public String toString(String ... paramNames) {
        StringBuilder base = new StringBuilder();
        base.append(this.type);
        base.append("/");
        base.append(this.subtype);
        for (String key : paramNames) {
            if (this.parameters.get(key) == null) continue;
            base.append("; ");
            base.append(key);
            base.append("=");
            base.append(this.parameters.get(key));
        }
        return base.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentType that = (ContentType)o;
        if (!this.charset.equals(that.charset)) {
            return false;
        }
        if (!((Object)this.parameters).equals(that.parameters)) {
            return false;
        }
        if (!this.subtype.equals(that.subtype)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.charset.hashCode();
        result = 31 * result + ((Object)this.parameters).hashCode();
        return result;
    }

    @Override
    public int compareTo(ContentType o) {
        return 8 * this.compareType(this.type, o.getType()) + 4 * this.compareType(this.subtype, o.getSubtype()) + 2 * this.compareParameters(this.parameters, o.parameters) + 1 * this.compareQ(this.parameters.get("q"), o.parameters.get("q"));
    }

    private int compareType(String t1, String t2) {
        if ("*".equals(t1) && !"*".equals(t2)) {
            return 1;
        }
        if (!"*".equals(t1) && "*".equals(t2)) {
            return -1;
        }
        return 0;
    }

    private int compareParameters(Map<String, String> p1, Map<String, String> p2) {
        if (p1.size() > p2.size()) {
            return -1;
        }
        if (p1.size() < p2.size()) {
            return 1;
        }
        return 0;
    }

    private int compareQ(String s1, String s2) {
        double q1 = 0.0;
        double q2 = 0.0;
        if (s1 != null) {
            try {
                q1 = Double.parseDouble(s1);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (s2 != null) {
            try {
                q2 = Double.parseDouble(s2);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return (int)Math.signum(q2 - q1);
    }
}

