/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.api.backend;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ThreadPoolExecutor;

public interface RDFBackend<Node> {
    public boolean supportsThreading();

    public ThreadPoolExecutor getThreadPool();

    public boolean isLiteral(Node var1);

    public boolean isURI(Node var1);

    public boolean isBlank(Node var1);

    public Locale getLiteralLanguage(Node var1);

    public URI getLiteralType(Node var1);

    public Node createLiteral(String var1);

    public Node createLiteral(String var1, Locale var2, URI var3);

    public Node createURI(String var1);

    public String stringValue(Node var1);

    public Double doubleValue(Node var1);

    public Long longValue(Node var1);

    public Boolean booleanValue(Node var1);

    public Date dateTimeValue(Node var1);

    public Date dateValue(Node var1);

    public Date timeValue(Node var1);

    public Float floatValue(Node var1);

    public Integer intValue(Node var1);

    public BigInteger integerValue(Node var1);

    public BigDecimal decimalValue(Node var1);

    public Collection<Node> listObjects(Node var1, Node var2);

    public Collection<Node> listSubjects(Node var1, Node var2);
}

