/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.backend.kiwi.sail;

import info.aduna.iteration.CloseableIteration;
import java.sql.SQLException;
import org.apache.marmotta.kiwi.sail.KiWiSailConnection;
import org.apache.marmotta.kiwi.sail.KiWiValueFactory;
import org.apache.marmotta.ldcache.backend.kiwi.model.KiWiCacheEntry;
import org.apache.marmotta.ldcache.backend.kiwi.persistence.LDCachingKiWiPersistenceConnection;
import org.apache.marmotta.ldcache.model.CacheEntry;
import org.apache.marmotta.ldcache.sail.LDCachingSailConnection;
import org.openrdf.model.URI;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailConnectionWrapper;

public class LDCachingKiWiSailConnection
extends SailConnectionWrapper
implements LDCachingSailConnection {
    private LDCachingKiWiPersistenceConnection persistence;
    private KiWiSailConnection wrapped;

    public LDCachingKiWiSailConnection(KiWiSailConnection wrappedCon) throws SailException {
        super((SailConnection)wrappedCon);
        this.wrapped = wrappedCon;
        try {
            this.persistence = new LDCachingKiWiPersistenceConnection(wrappedCon.getDatabaseConnection());
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }

    public KiWiValueFactory getValueFactory() {
        return this.wrapped.getValueFactory();
    }

    public void addCacheEntry(URI resource, CacheEntry entry) throws SailException {
        try {
            this.persistence.storeCacheEntry(entry);
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CacheEntry getCacheEntry(URI resource) throws SailException {
        try {
            return this.persistence.getCacheEntry(resource.stringValue());
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }

    public void removeCacheEntry(URI resource) throws SailException {
        try {
            this.persistence.removeCacheEntry(resource.stringValue());
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CloseableIteration<KiWiCacheEntry, SQLException> listExpired() throws SailException {
        try {
            return this.persistence.listExpired();
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }

    public CloseableIteration<KiWiCacheEntry, SQLException> listAll() throws SailException {
        try {
            return this.persistence.listAll();
        }
        catch (SQLException e) {
            throw new SailException((Throwable)e);
        }
    }
}

