/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.backend.kiwi.repository;

import org.apache.marmotta.kiwi.contextaware.ContextAwareSailConnection;
import org.apache.marmotta.ldcache.api.LDCachingConnection;
import org.apache.marmotta.ldcache.backend.kiwi.sail.LDCachingKiWiSailConnection;
import org.apache.marmotta.ldcache.model.CacheEntry;
import org.apache.marmotta.ldcache.sail.LDCachingSailConnection;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class LDCachingSailRepositoryConnection
extends SailRepositoryConnection
implements LDCachingConnection {
    private LDCachingSailConnection cacheConnection;

    public LDCachingSailRepositoryConnection(SailRepository repository, LDCachingKiWiSailConnection sailConnection, String cacheContext) {
        super(repository, (SailConnection)new ContextAwareSailConnection((SailConnection)sailConnection, (Resource)sailConnection.getValueFactory().createURI(cacheContext)));
        this.cacheConnection = sailConnection;
    }

    public void addCacheEntry(URI resource, CacheEntry entry) throws RepositoryException {
        try {
            this.cacheConnection.addCacheEntry(resource, entry);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public CacheEntry getCacheEntry(URI resource) throws RepositoryException {
        try {
            return this.cacheConnection.getCacheEntry(resource);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeCacheEntry(URI resource) throws RepositoryException {
        try {
            this.cacheConnection.removeCacheEntry(resource);
        }
        catch (SailException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

