/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldcache.backend.kiwi.persistence;

import info.aduna.iteration.CloseableIteration;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.marmotta.kiwi.model.rdf.KiWiNode;
import org.apache.marmotta.kiwi.model.rdf.KiWiResource;
import org.apache.marmotta.kiwi.persistence.KiWiConnection;
import org.apache.marmotta.kiwi.persistence.util.ResultSetIteration;
import org.apache.marmotta.kiwi.persistence.util.ResultTransformerFunction;
import org.apache.marmotta.ldcache.backend.kiwi.model.KiWiCacheEntry;
import org.apache.marmotta.ldcache.model.CacheEntry;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDCachingKiWiPersistenceConnection {
    private static Logger log = LoggerFactory.getLogger(LDCachingKiWiPersistenceConnection.class);
    private KiWiConnection connection;
    private Cache entryResourceCache;
    private Cache entryIdCache;

    public LDCachingKiWiPersistenceConnection(KiWiConnection connection) throws SQLException {
        this.connection = connection;
        this.entryResourceCache = connection.getCacheManager().getCacheByName("ldcache-entry-uri");
        this.entryIdCache = connection.getCacheManager().getCacheByName("ldcache-entry-id");
    }

    public KiWiCacheEntry constructCacheEntry(ResultSet row) throws SQLException {
        Long id = row.getLong("id");
        Element cached = this.entryIdCache.get((Serializable)id);
        if (cached != null) {
            return (KiWiCacheEntry)((Object)cached.getObjectValue());
        }
        KiWiCacheEntry entry = new KiWiCacheEntry();
        entry.setId(id);
        entry.setLastRetrieved(new Date(row.getTimestamp("retrieved_at").getTime()));
        entry.setExpiryDate(new Date(row.getTimestamp("expires_at").getTime()));
        entry.setUpdateCount(row.getInt("update_count"));
        entry.setResource((URI)this.connection.loadNodeById(Long.valueOf(row.getLong("resource_id"))));
        this.entryIdCache.put(new Element((Object)id, (Object)entry));
        this.entryResourceCache.put(new Element((Object)entry.getResource().stringValue(), (Object)entry));
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KiWiCacheEntry getCacheEntry(String uri) throws SQLException {
        Element cached = this.entryResourceCache.get((Serializable)((Object)uri));
        if (cached != null) {
            return (KiWiCacheEntry)((Object)cached.getObjectValue());
        }
        PreparedStatement query = this.connection.getPreparedStatement("load.entry_by_uri");
        query.setString(1, uri);
        query.setMaxRows(1);
        ResultSet result = query.executeQuery();
        try {
            if (result.next()) {
                KiWiCacheEntry kiWiCacheEntry = this.constructCacheEntry(result);
                return kiWiCacheEntry;
            }
            KiWiCacheEntry kiWiCacheEntry = null;
            return kiWiCacheEntry;
        }
        finally {
            result.close();
        }
    }

    public void storeCacheEntry(CacheEntry entry) throws SQLException {
        KiWiCacheEntry kEntry;
        if (entry instanceof KiWiCacheEntry) {
            kEntry = (KiWiCacheEntry)entry;
        } else {
            kEntry = new KiWiCacheEntry();
            kEntry.setExpiryDate(entry.getExpiryDate());
            kEntry.setLastRetrieved(entry.getLastRetrieved());
            kEntry.setUpdateCount(entry.getUpdateCount());
            kEntry.setResource(entry.getResource());
        }
        if (!(entry.getResource() instanceof KiWiResource) || ((KiWiResource)entry.getResource()).getId() == null) {
            throw new IllegalStateException("the resource contained in the cache entry is not a KiWiResource!");
        }
        kEntry.setId(this.connection.getNextSequence("seq.ldcache"));
        PreparedStatement insertEntry = this.connection.getPreparedStatement("store.entry");
        insertEntry.setLong(1, kEntry.getId());
        insertEntry.setTimestamp(2, new Timestamp(kEntry.getLastRetrieved().getTime()));
        insertEntry.setTimestamp(3, new Timestamp(kEntry.getExpiryDate().getTime()));
        insertEntry.setLong(4, ((KiWiNode)kEntry.getResource()).getId());
        insertEntry.setInt(5, kEntry.getUpdateCount());
        insertEntry.executeUpdate();
        log.debug("persisted ld-cache entry with id {}", (Object)kEntry.getId());
        this.entryIdCache.put(new Element((Object)kEntry.getId(), (Object)kEntry));
        this.entryResourceCache.put(new Element((Object)kEntry.getResource().stringValue(), (Object)kEntry));
    }

    public void removeCacheEntry(CacheEntry entry) throws SQLException {
        if (!(entry instanceof KiWiCacheEntry) || ((KiWiCacheEntry)entry).getId() == null) {
            throw new IllegalStateException("the passed cache entry is not managed by this connection");
        }
        PreparedStatement deleteEntry = this.connection.getPreparedStatement("delete.entry");
        deleteEntry.setLong(1, ((KiWiCacheEntry)entry).getId());
        deleteEntry.executeUpdate();
        this.entryIdCache.remove((Serializable)((KiWiCacheEntry)entry).getId());
        this.entryResourceCache.remove((Serializable)((Object)entry.getResource().stringValue()));
    }

    public void removeCacheEntry(String uri) throws SQLException {
        PreparedStatement deleteEntry = this.connection.getPreparedStatement("delete.entry_by_uri");
        deleteEntry.setString(1, uri);
        deleteEntry.executeUpdate();
        Element cached = this.entryResourceCache.get((Serializable)((Object)uri));
        if (cached != null) {
            this.entryResourceCache.remove((Serializable)((Object)uri));
            this.entryIdCache.remove((Serializable)((KiWiCacheEntry)((Object)cached.getObjectValue())).getId());
        }
    }

    public CloseableIteration<KiWiCacheEntry, SQLException> listExpired() throws SQLException {
        PreparedStatement queryExpired = this.connection.getPreparedStatement("query.entries_expired");
        final ResultSet result = queryExpired.executeQuery();
        return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<KiWiCacheEntry>(){

            public KiWiCacheEntry apply(ResultSet input) throws SQLException {
                return LDCachingKiWiPersistenceConnection.this.constructCacheEntry(result);
            }
        });
    }

    public CloseableIteration<KiWiCacheEntry, SQLException> listAll() throws SQLException {
        PreparedStatement queryExpired = this.connection.getPreparedStatement("query.entries_all");
        final ResultSet result = queryExpired.executeQuery();
        return new ResultSetIteration(result, (ResultTransformerFunction)new ResultTransformerFunction<KiWiCacheEntry>(){

            public KiWiCacheEntry apply(ResultSet input) throws SQLException {
                return LDCachingKiWiPersistenceConnection.this.constructCacheEntry(result);
            }
        });
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void storeNode(KiWiNode node) throws SQLException {
        this.connection.storeNode(node);
    }

    public Set<String> getDatabaseTables() throws SQLException {
        return this.connection.getDatabaseTables();
    }

    public int getDatabaseVersion() throws SQLException {
        return this.connection.getDatabaseVersion();
    }
}

